/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Collection;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.UserTask;

public class BpmnModelInstanceCmdTest
extends PluggableProcessEngineTestCase {
    private static final String PROCESS_KEY = "process";
    private String deploymentId;

    public void testRepositoryService() {
        this.deployTestProcess();
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_KEY).singleResult()).getId();
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        BpmnModelInstanceCmdTest.assertNotNull((Object)modelInstance);
        Collection events = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Event.class));
        BpmnModelInstanceCmdTest.assertEquals((int)2, (int)events.size());
        Collection tasks = modelInstance.getModelElementsByType(modelInstance.getModel().getType(UserTask.class));
        BpmnModelInstanceCmdTest.assertEquals((int)1, (int)tasks.size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        UserTask userTask = (UserTask)modelInstance.getModelElementById(task.getTaskDefinitionKey());
        BpmnModelInstanceCmdTest.assertNotNull((Object)userTask);
        this.taskService.complete(task.getId());
    }

    private void deployTestProcess() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)PROCESS_KEY).startEvent().userTask().endEvent().done();
        this.deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
    }

    public void tearDown() {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }
}

