/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.examples.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.variable.Variables;

public class ProcessInstanceModificationCancellationTest
extends PluggableProcessEngineTestCase {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml";
    protected static final String CONCURRENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String CONCURRENT_SCOPE_TASKS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml";
    protected static final String NESTED_PARALLEL_ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_PARALLEL_ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_PARALLEL_CONCURRENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml";
    protected static final String NESTED_PARALLEL_CONCURRENT_SCOPE_TASKS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml";
    protected static final String LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.listenerProcess.bpmn20.xml";
    protected static final String FAILING_OUTPUT_MAPPINGS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.failingOutputMappingProcess.bpmn20.xml";
    protected static final String INTERRUPTING_EVENT_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testCancellationInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testCancelAllInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theTask").execute();
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("theTask").execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testCancellationAndCreationInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).startBeforeActivity("theTask").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)tree.getId(), (String)updatedTree.getId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testCreationAndCancellationInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask").cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    public void testCancellationInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    public void FAILING_testCancelAllInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask").execute();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("theTask").execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    public void testCancellationAndCreationInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).startBeforeActivity("theTask").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    public void testCreationAndCancellationInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask").cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    public void testCancellationInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    public void testCancelAllInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("task1").execute();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("task1").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    public void testCancellationAndCreationInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task1").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    public void testCreationAndCancellationInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1").cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    public void testCancellationInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    public void testCancelAllInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1").execute();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("task1").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    public void testCancellationAndCreationInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task1").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).noScope().concurrent().child("task1").scope().up().up().child(null).noScope().concurrent().child("task2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    public void testCreationAndCancellationInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1").cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).noScope().concurrent().child("task1").scope().up().up().child(null).noScope().concurrent().child("task2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    public void testCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    public void testScopeCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    public void FAILING_testScopeCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    public void testCancellationAndCreationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).startBeforeActivity("innerTask").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    public void testCreationAndCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask").cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    public void testCancellationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    public void testScopeCancellationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    public void testCancellationAndCreationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).startBeforeActivity("innerTask").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    public void testCreationAndCancellationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask").cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    public void testCancellationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    public void FAILING_testScopeCancellationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("fork").scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    public void testCancellationAndCreationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).startBeforeActivity("innerTask1").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").noScope().concurrent().up().child(null).noScope().concurrent().child(null).scope().child("innerTask1").noScope().concurrent().up().child("innerTask2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)3, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    public void testCreationAndCancellationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask1").cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").noScope().concurrent().up().child(null).noScope().concurrent().child(null).scope().child("innerTask1").noScope().concurrent().up().child("innerTask2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)3, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    public void testCancellationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    public void FAILING_testScopeCancellationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("fork").scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    public void testCancellationAndCreationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).startBeforeActivity("innerTask1").execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child(null).concurrent().noScope().child("innerTask1").scope().up().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)3, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    public void testCreationAndCancellationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask1").cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ProcessInstanceModificationCancellationTest.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).noScope().concurrent().child(null).scope().child(null).concurrent().noScope().child("innerTask1").scope().up().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceModificationCancellationTest.assertEquals((int)3, (int)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.listenerProcess.bpmn20.xml"})
    public void testEndListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("listenerProcess", Collections.singletonMap("listener", new RecorderExecutionListener()));
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        ProcessInstanceModificationCancellationTest.assertEquals((int)1, (int)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent innerTask1EndEvent = RecorderExecutionListener.getRecordedEvents().get(0);
        ProcessInstanceModificationCancellationTest.assertEquals((String)"end", (String)innerTask1EndEvent.getEventName());
        ProcessInstanceModificationCancellationTest.assertEquals((String)"innerTask1", (String)innerTask1EndEvent.getActivityId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)this.getInstanceIdForActivity(tree, "innerTask1"), (String)innerTask1EndEvent.getActivityInstanceId());
        RecorderExecutionListener.clear();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask2")).execute();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent innerTask2EndEvent = RecorderExecutionListener.getRecordedEvents().get(0);
        ProcessInstanceModificationCancellationTest.assertEquals((String)"end", (String)innerTask2EndEvent.getEventName());
        ProcessInstanceModificationCancellationTest.assertEquals((String)"innerTask2", (String)innerTask2EndEvent.getActivityId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)this.getInstanceIdForActivity(tree, "innerTask2"), (String)innerTask2EndEvent.getActivityInstanceId());
        RecorderExecutionListener.RecordedEvent subProcessEndEvent = RecorderExecutionListener.getRecordedEvents().get(1);
        ProcessInstanceModificationCancellationTest.assertEquals((String)"end", (String)subProcessEndEvent.getEventName());
        ProcessInstanceModificationCancellationTest.assertEquals((String)"subProcess", (String)subProcessEndEvent.getActivityId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)this.getInstanceIdForActivity(tree, "subProcess"), (String)subProcessEndEvent.getActivityInstanceId());
        RecorderExecutionListener.clear();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "outerTask")).execute();
        ProcessInstanceModificationCancellationTest.assertEquals((int)2, (int)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent outerTaskEndEvent = RecorderExecutionListener.getRecordedEvents().get(0);
        ProcessInstanceModificationCancellationTest.assertEquals((String)"end", (String)outerTaskEndEvent.getEventName());
        ProcessInstanceModificationCancellationTest.assertEquals((String)"outerTask", (String)outerTaskEndEvent.getActivityId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)this.getInstanceIdForActivity(tree, "outerTask"), (String)outerTaskEndEvent.getActivityInstanceId());
        RecorderExecutionListener.RecordedEvent processEndEvent = RecorderExecutionListener.getRecordedEvents().get(1);
        ProcessInstanceModificationCancellationTest.assertEquals((String)"end", (String)processEndEvent.getEventName());
        ProcessInstanceModificationCancellationTest.assertNull((Object)processEndEvent.getActivityId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)tree.getId(), (String)processEndEvent.getActivityInstanceId());
        RecorderExecutionListener.clear();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.failingOutputMappingProcess.bpmn20.xml"})
    public void testSkipOutputMappingsOnCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingOutputMappingProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute(false, true);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "outerTask")).execute(false, true);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml"})
    public void testProcessInstanceEventSubscriptionsPreservedOnIntermediateCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)subscription);
        ProcessInstanceModificationCancellationTest.assertEquals((String)processInstance.getId(), (String)subscription.getProcessInstanceId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task1").execute();
        EventSubscription updatedSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)updatedSubscription);
        ProcessInstanceModificationCancellationTest.assertEquals((String)subscription.getId(), (String)updatedSubscription.getId());
        ProcessInstanceModificationCancellationTest.assertEquals((String)subscription.getProcessInstanceId(), (String)updatedSubscription.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testProcessInstanceVariablesPreservedOnIntermediateCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"value"));
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).startBeforeActivity("theTask").execute();
        Object variable = this.runtimeService.getVariable(processInstance.getId(), "var");
        ProcessInstanceModificationCancellationTest.assertNotNull((Object)variable);
        ProcessInstanceModificationCancellationTest.assertEquals((Object)"value", (Object)variable);
    }

    public String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    public ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }
}

