/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public abstract class AuthorizationTest
extends PluggableProcessEngineTestCase {
    protected String userId = "test";
    protected String groupId = "accounting";
    protected User user;
    protected Group group;

    protected void initializeProcessEngine() {
        super.initializeProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)AuthorizationTest.getProcessEngine().getProcessEngineConfiguration();
        this.identityService = this.processEngineConfiguration.getIdentityService();
        this.authorizationService = this.processEngineConfiguration.getAuthorizationService();
        this.user = this.createUser(this.userId);
        this.group = this.createGroup(this.groupId);
        this.identityService.createMembership(this.userId, this.groupId);
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    public void tearDown() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    protected User createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.AUTHORIZATION, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createGrantAuthorization((Resource)Resources.USER, "*");
        authorization.setUserId(userId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        return user;
    }

    protected Group createGroup(String groupId) {
        Group group = this.identityService.newGroup(groupId);
        this.identityService.saveGroup(group);
        return group;
    }

    protected void createGrantAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected void createRevokeAuthorization(Resource resource, String resourceId, String userId, Permission ... permissions) {
        Authorization authorization = this.createRevokeAuthorization(resource, resourceId);
        authorization.setUserId(userId);
        for (Permission permission : permissions) {
            authorization.removePermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected Authorization createGlobalAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(0, resource, resourceId);
        return authorization;
    }

    protected Authorization createGrantAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(1, resource, resourceId);
        return authorization;
    }

    protected Authorization createRevokeAuthorization(Resource resource, String resourceId) {
        Authorization authorization = this.createAuthorization(2, resource, resourceId);
        return authorization;
    }

    protected Authorization createAuthorization(int type, Resource resource, String resourceId) {
        Authorization authorization = this.authorizationService.createNewAuthorization(type);
        authorization.setResource(resource);
        if (resourceId != null) {
            authorization.setResourceId(resourceId);
        }
        return authorization;
    }

    protected void saveAuthorization(Authorization authorization) {
        this.authorizationService.saveAuthorization(authorization);
    }

    protected void enableAuthorization() {
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    protected void disableAuthorization() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
    }

    protected ProcessInstance startProcessInstanceByKey(String key) {
        return this.startProcessInstanceByKey(key, null);
    }

    protected ProcessInstance startProcessInstanceByKey(String key, Map<String, Object> variables) {
        this.disableAuthorization();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, variables);
        this.enableAuthorization();
        return processInstance;
    }

    public void executeAvailableJobs() {
        this.disableAuthorization();
        super.executeAvailableJobs();
        this.enableAuthorization();
    }

    protected CaseInstance createCaseInstanceByKey(String key) {
        return this.createCaseInstanceByKey(key, null);
    }

    protected CaseInstance createCaseInstanceByKey(String key, Map<String, Object> variables) {
        this.disableAuthorization();
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey(key, variables);
        this.enableAuthorization();
        return caseInstance;
    }

    protected void createTask(String taskId) {
        this.disableAuthorization();
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.enableAuthorization();
    }

    protected void deleteTask(String taskId, boolean cascade) {
        this.disableAuthorization();
        this.taskService.deleteTask(taskId, cascade);
        this.enableAuthorization();
    }

    protected void addCandidateUser(String taskId, String user) {
        this.disableAuthorization();
        this.taskService.addCandidateUser(taskId, user);
        this.enableAuthorization();
    }

    protected void addCandidateGroup(String taskId, String group) {
        this.disableAuthorization();
        this.taskService.addCandidateGroup(taskId, group);
        this.enableAuthorization();
    }

    protected void setAssignee(String taskId, String userId) {
        this.disableAuthorization();
        this.taskService.setAssignee(taskId, userId);
        this.enableAuthorization();
    }

    protected void delegateTask(String taskId, String userId) {
        this.disableAuthorization();
        this.taskService.delegateTask(taskId, userId);
        this.enableAuthorization();
    }

    protected Task selectSingleTask() {
        this.disableAuthorization();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.enableAuthorization();
        return task;
    }

    protected void setTaskVariable(String taskId, String name, Object value) {
        this.disableAuthorization();
        this.taskService.setVariable(taskId, name, value);
        this.enableAuthorization();
    }

    protected void setTaskVariableLocal(String taskId, String name, Object value) {
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, name, value);
        this.enableAuthorization();
    }

    protected void setExecutionVariable(String executionId, String name, Object value) {
        this.disableAuthorization();
        this.runtimeService.setVariable(executionId, name, value);
        this.enableAuthorization();
    }

    protected void setExecutionVariableLocal(String executionId, String name, Object value) {
        this.disableAuthorization();
        this.runtimeService.setVariableLocal(executionId, name, value);
        this.enableAuthorization();
    }

    protected void setCaseVariable(String caseExecution, String name, Object value) {
        this.disableAuthorization();
        this.caseService.setVariable(caseExecution, name, value);
        this.enableAuthorization();
    }

    protected void setCaseVariableLocal(String caseExecution, String name, Object value) {
        this.disableAuthorization();
        this.caseService.setVariableLocal(caseExecution, name, value);
        this.enableAuthorization();
    }

    protected ProcessDefinition selectProcessDefinitionByKey(String processDefinitionKey) {
        this.disableAuthorization();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).singleResult();
        this.enableAuthorization();
        return definition;
    }

    protected ProcessInstance selectSingleProcessInstance() {
        this.disableAuthorization();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        this.enableAuthorization();
        return instance;
    }

    protected void suspendProcessInstanceById(String processInstanceId) {
        this.disableAuthorization();
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.enableAuthorization();
    }

    protected void verifyQueryResults(AbstractQuery<?, ?> query, int countExpected) {
        AuthorizationTest.assertEquals((int)countExpected, (int)query.list().size());
        AuthorizationTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            AuthorizationTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            AuthorizationTest.assertNull((Object)query.singleResult());
        }
    }

    protected void verifySingleResultFails(AbstractQuery<?, ?> query) {
        try {
            query.singleResult();
            AuthorizationTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

