/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class IncidentAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "process";
    protected static final String ANOTHER_ONE_INCIDENT_PROCESS_KEY = "anotherOneIncidentProcess";
    protected String deploymentId;

    public void setUp() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/authorization/oneIncidentProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/authorization/anotherOneIncidentProcess.bpmn20.xml").deploy().getId();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(PROCESS_KEY);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessAndExecuteJob(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessAndExecuteJob(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessAndExecuteJob(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        String processInstanceId = this.startProcessAndExecuteJob(PROCESS_KEY).getId();
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 1);
        Incident incident = (Incident)query.singleResult();
        IncidentAuthorizationTest.assertNotNull((Object)incident);
        IncidentAuthorizationTest.assertEquals((String)processInstanceId, (String)incident.getProcessInstanceId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ANOTHER_ONE_INCIDENT_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        IncidentQuery query = this.runtimeService.createIncidentQuery();
        this.verifyQueryResults(query, 7);
    }

    protected ProcessInstance startProcessAndExecuteJob(String key) {
        ProcessInstance processInstance = this.startProcessInstanceByKey(key);
        this.executeAvailableJobs();
        return processInstance;
    }

    protected void verifyQueryResults(IncidentQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }
}

