/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.io.InputStream;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class ProcessDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String TWO_TASKS_PROCESS_KEY = "twoTasksProcess";
    protected String deploymentId;

    public void setUp() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml").deploy().getId();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    public void testQueryWithoutAuthorization() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 2);
    }

    public void testQueryWithReadPermissionOnOneTaskProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
        ProcessDefinitionAuthorizationTest.assertEquals((String)ONE_TASK_PROCESS_KEY, (String)definition.getKey());
    }

    public void testQueryWithRevokedReadPermission() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        Authorization authorization = this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.removePermission((Permission)Permissions.READ);
        this.saveAuthorization(authorization);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
        ProcessDefinitionAuthorizationTest.assertEquals((String)TWO_TASKS_PROCESS_KEY, (String)definition.getKey());
    }

    public void testQueryWithGroupAuthorizationRevokedReadPermission() {
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*");
        authorization.setGroupId(this.groupId);
        authorization.addPermission((Permission)Permissions.ALL);
        this.saveAuthorization(authorization);
        authorization = this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY);
        authorization.setGroupId(this.groupId);
        authorization.removePermission((Permission)Permissions.READ);
        this.saveAuthorization(authorization);
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinition definition = (ProcessDefinition)query.singleResult();
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
        ProcessDefinitionAuthorizationTest.assertEquals((String)TWO_TASKS_PROCESS_KEY, (String)definition.getKey());
    }

    public void testGetProcessDefinitionWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDefinition(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process definition");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)definition);
    }

    public void testGetProcessDiagramWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessDiagram(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process diagram");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessDiagram() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getProcessDiagram(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNull((Object)stream);
    }

    public void testGetProcessModelWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        try {
            this.repositoryService.getProcessModel(processDefinitionId);
            ProcessDefinitionAuthorizationTest.fail((String)"Exception expected: It should not be possible to get the process model");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_TASK_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetProcessModel() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_TASK_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getProcessModel(processDefinitionId);
        ProcessDefinitionAuthorizationTest.assertNotNull((Object)stream);
    }

    protected void verifyQueryResults(ProcessDefinitionQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }
}

