/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class ProcessDefinitionStatisticsAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_TASK_PROCESS_KEY = "oneTaskProcess";
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected String deploymentId;

    public void setUp() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/authorization/oneIncidentProcess.bpmn20.xml").deploy().getId();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    public void testQueryWithoutAuthorizations() {
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnOneTaskProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 1);
        ProcessDefinitionStatistics statistics = (ProcessDefinitionStatistics)query.singleResult();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((String)ONE_TASK_PROCESS_KEY, (String)statistics.getKey());
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getInstances());
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ProcessDefinitionStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryWithReadPermissionOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        this.verifyQueryResults(query, 2);
        List statistics = query.list();
        for (ProcessDefinitionStatistics result : statistics) {
            this.verifyStatisticsResult(result, 0, 0, 0);
        }
    }

    public void testQueryIncludingInstancesWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            this.verifyStatisticsResult(result, 0, 0, 0);
        }
    }

    public void testQueryIncludingInstancesWithReadPermissionOnFirstProcessInstance() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 1, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 0, 0, 0);
    }

    public void testQueryIncludingInstancesWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 0);
    }

    public void testQueryIncludingInstancesWithReadInstancePermissionOnOneTaskProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_TASK_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 0, 0, 0);
    }

    public void testQueryIncludingInstancesWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 0);
    }

    public void testQueryIncludingFailedJobsWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            this.verifyStatisticsResult(result, 0, 0, 0);
        }
    }

    public void testQueryIncludingFailedJobsWithReadPermissionOnFirstProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String firstProcessInstanceId = this.startOneIncidentProcessAndExecuteJob().getId();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 0, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 1, 1, 0);
    }

    public void testQueryIncludingFailedJobsWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 0);
    }

    public void testQueryIncludingFailedJobsWithReadInstancePermissionOnOneIncidentProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 0, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 0);
    }

    public void testQueryIncludingFailedJobsWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 0);
    }

    public void testQueryIncludingIncidentsWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            this.verifyStatisticsResult(result, 0, 0, 0);
        }
    }

    public void testQueryIncludingIncidentsWithReadPermissionOnFirstProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String firstProcessInstanceId = this.startOneIncidentProcessAndExecuteJob().getId();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 0, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 1, 0, 1);
    }

    public void testQueryIncludingIncidentsWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 3);
    }

    public void testQueryIncludingIncidentsWithReadInstancePermissionOnOneIncidentProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 0, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 3);
    }

    public void testQueryIncludingIncidentsWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 0, 3);
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithoutProcessInstanceAuthorizations() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        for (ProcessDefinitionStatistics result : statistics) {
            this.verifyStatisticsResult(result, 0, 0, 0);
        }
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadPermissionOnFirstProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY).getId();
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        String firstProcessInstanceId = this.startOneIncidentProcessAndExecuteJob().getId();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 0, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 1, 1, 1);
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 3);
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadInstancePermissionOnOneIncidentProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 0, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 3);
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadInstancePermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startProcessInstanceByKey(ONE_TASK_PROCESS_KEY);
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.startOneIncidentProcessAndExecuteJob();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createProcessDefinitionStatisticsQuery().includeIncidents().includeFailedJobs().list();
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((int)2, (int)statistics.size());
        ProcessDefinitionStatistics oneTaskProcessStatistics = this.getStatisticsByKey(statistics, ONE_TASK_PROCESS_KEY);
        this.verifyStatisticsResult(oneTaskProcessStatistics, 2, 0, 0);
        ProcessDefinitionStatistics oneIncidentProcessStatistics = this.getStatisticsByKey(statistics, ONE_INCIDENT_PROCESS_KEY);
        this.verifyStatisticsResult(oneIncidentProcessStatistics, 3, 3, 3);
    }

    protected void verifyQueryResults(ProcessDefinitionStatisticsQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }

    protected void verifyStatisticsResult(ProcessDefinitionStatistics statistics, int instances, int failedJobs, int incidents) {
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((String)"Instances", (int)instances, (int)statistics.getInstances());
        ProcessDefinitionStatisticsAuthorizationTest.assertEquals((String)"Failed Jobs", (int)failedJobs, (int)statistics.getFailedJobs());
        List incidentStatistics = statistics.getIncidentStatistics();
        if (incidents == 0) {
            ProcessDefinitionStatisticsAuthorizationTest.assertTrue((String)"Incidents supposed to be empty", (boolean)incidentStatistics.isEmpty());
        } else {
            ProcessDefinitionStatisticsAuthorizationTest.assertEquals((String)"Incidents", (int)incidents, (int)((IncidentStatistics)incidentStatistics.get(0)).getIncidentCount());
        }
    }

    protected ProcessInstance startOneIncidentProcessAndExecuteJob() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(ONE_INCIDENT_PROCESS_KEY);
        this.executeAvailableJobs();
        return processInstance;
    }

    protected ProcessDefinitionStatistics getStatisticsByKey(List<ProcessDefinitionStatistics> statistics, String key) {
        for (ProcessDefinitionStatistics result : statistics) {
            if (!key.equals(result.getKey())) continue;
            return result;
        }
        ProcessDefinitionStatisticsAuthorizationTest.fail((String)("No statistics found for key '" + key + "'."));
        return null;
    }
}

