/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;

public class ProcessInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String MESSAGE_BOUNDARY_PROCESS_KEY = "messageBoundaryProcess";
    protected static final String SIGNAL_BOUNDARY_PROCESS_KEY = "signalBoundaryProcess";
    protected String deploymentId;

    public void setUp() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/authorization/messageStartEventProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/authorization/messageBoundaryEventProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/authorization/signalBoundaryEventProcess.bpmn20.xml").deploy().getId();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testStartProcessInstanceByKeyWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByMessageWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessage() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefId() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.deleteProcessInstance(processInstanceId, null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a process instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessInstanceWithDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithDeleteInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testGetActiveActivityIdsWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActiveActivityIds(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve active ativity ids");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    public void testGetActiveActivityIdsWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIdsWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIdsWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActivityInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActivityInstance(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve ativity instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetActivityInstanceWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testSignalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.signal(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to signal an execution");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignalWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignal() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testSignalEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.signalEventReceived("alert");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceived() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.signalEventReceived("alert");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(secondProcessInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    public void testSignalEventReceivedByExecutionIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.signalEventReceived("alert", executionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a message event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.correlateMessage("boundaryInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateMessageExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.correlateMessage("startInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateAllExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(secondProcessInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateAllTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    public void testCorrelateAllProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void testSuspendProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to activate a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.startProcessInstanceByKey(PROCESS_KEY).getProcessDefinitionId();
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    public void testSuspendProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    public void testActivateProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    public void testModifyProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent").execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testModifyProcessInstanceWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent").execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstanceWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent").execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstanceWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent").execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent").execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeleteAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        try {
            this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeleteInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.UPDATE_INSTANCE);
        authorization.addPermission((Permission)Permissions.DELETE_INSTANCE);
        this.saveAuthorization(authorization);
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testClearProcessInstanceAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)authorization);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNull((Object)authorization);
    }

    public void testDeleteProcessInstanceClearAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)authorization);
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNull((Object)authorization);
    }

    protected void verifyQueryResults(ProcessInstanceQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }
}

