/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.authorization;

import java.util.Map;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.test.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class VariableInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    protected String deploymentId;

    public void setUp() {
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/authorization/oneTaskCase.cmmn").deploy().getId();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }

    public void testProcessVariableQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testCaseVariableQueryWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testProcessLocalTaskVariableQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testCaseLocalTaskVariableQueryWithoutAuthorization() {
        this.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testStandaloneTaskVariableQueryWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    public void testProcessVariableQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testProcessVariableQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testProcessLocalTaskVariableQueryWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testProcessLocalTaskVariableQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testProcessLocalTaskVariableQueryWithReadPermissionOnOneProcessTask() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.setTaskVariableLocal(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        VariableInstance variable = (VariableInstance)query.singleResult();
        VariableInstanceAuthorizationTest.assertNotNull((Object)variable);
        VariableInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)variable.getProcessInstanceId());
    }

    public void testStandaloneTaskVariableQueryWithReadPermissionOnTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setTaskVariable(taskId, VARIABLE_NAME, VARIABLE_VALUE);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((AbstractQuery)query, countExpected);
    }
}

