/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.signal.DummyServiceTask;

public class SignalEventTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testSignalCatchIntermediate() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundary.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testSignalCatchBoundary() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignalBoundaryWithReceiveTask.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml"})
    public void testSignalCatchBoundaryWithVariables() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("processName", "catchSignal");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("catchSignal", variables1);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("processName", "throwSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignal", variables2);
        SignalEventTest.assertEquals((Object)"catchSignal", (Object)this.runtimeService.getVariable(pi.getId(), "processName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignalAsynch.bpmn20.xml"})
    public void testSignalCatchIntermediateAsynch() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        try {
            ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 1000L));
            this.waitForJobExecutorToProcessAllJobs(10000L);
            SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
            SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
            SignalEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        }
        finally {
            ClockUtil.setCurrentTime((Date)new Date());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.catchMultipleSignals.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAlertSignal.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.throwAbortSignal.bpmn20.xml"})
    public void testSignalCatchDifferentSignals() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        SignalEventTest.assertEquals((long)2L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("throwAbort");
        SignalEventTest.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Task taskAfterAbort = (Task)this.taskService.createTaskQuery().taskAssignee("gonzo").singleResult();
        SignalEventTest.assertNotNull((Object)taskAfterAbort);
        this.taskService.complete(taskAfterAbort.getId());
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        SignalEventTest.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        SignalEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testSignalBoundaryOnSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("signalEventOnSubprocess");
        this.runtimeService.signalEventReceived("stopSignal");
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    public void testDuplicateSignalNames() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.duplicateSignalNames.bpmn20.xml").deploy();
                SignalEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("duplicate signal name")) break block2;
                SignalEventTest.fail((String)"different exception expected");
            }
        }
    }

    public void testNoSignalName() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.noSignalName.bpmn20.xml").deploy();
                SignalEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("has no name")) break block2;
                SignalEventTest.fail((String)"different exception expected");
            }
        }
    }

    public void testSignalNoId() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.signalNoId.bpmn20.xml").deploy();
                SignalEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("signal must have an id")) break block2;
                SignalEventTest.fail((String)"different exception expected");
            }
        }
    }

    public void testSignalNoRef() {
        block2: {
            try {
                this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/signal/SignalEventTests.signalNoRef.bpmn20.xml").deploy();
                SignalEventTest.fail((String)"exception expected");
            }
            catch (Exception e) {
                if (e.getMessage().contains("signalEventDefinition does not have required property 'signalRef'")) break block2;
                SignalEventTest.fail((String)"different exception expected");
            }
        }
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }

    @Deployment
    public void testNonInterruptingSignal() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalEvent");
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        Task currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"My User Task", (String)currentTask.getName());
        this.runtimeService.signalEventReceived("alert");
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            if (task.getName().equals("My User Task") || task.getName().equals("My Second User Task")) continue;
            SignalEventTest.fail((String)("Expected: <My User Task> or <My Second User Task> but was <" + task.getName() + ">."));
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("My User Task").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"My Second User Task", (String)currentTask.getName());
    }

    @Deployment
    public void testNonInterruptingSignalWithSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalWithSubProcess");
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        Task currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"Approve", (String)currentTask.getName());
        this.runtimeService.signalEventReceived("alert");
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            if (task.getName().equals("Approve") || task.getName().equals("Review")) continue;
            SignalEventTest.fail((String)("Expected: <Approve> or <Review> but was <" + task.getName() + ">."));
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Approve").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
        currentTask = (Task)tasks.get(0);
        SignalEventTest.assertEquals((String)"Review", (String)currentTask.getName());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Review").singleResult()).getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).list();
        SignalEventTest.assertEquals((int)1, (int)tasks.size());
    }

    @Deployment
    public void testSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)0L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)0L, (long)executionQuery.count());
    }

    @Deployment
    public void testNonInterruptingSignalStartEventInEventSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nonInterruptingSignalStartEventInEventSubProcess");
        ExecutionQuery executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)executionQuery.count());
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)taskQuery.count());
        this.runtimeService.signalEventReceived("alert");
        SignalEventTest.assertEquals((boolean)true, (boolean)DummyServiceTask.wasExecuted);
        taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)taskQuery.count());
        executionQuery = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId());
        SignalEventTest.assertEquals((long)1L, (long)executionQuery.count());
    }
}

