/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class ParallelGatewayTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSplitMergeNoWaitstates() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("forkJoinNoWaitStates");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    public void testUnstructuredConcurrencyTwoForks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("unstructuredConcurrencyTwoForks");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    public void testUnstructuredConcurrencyTwoJoins() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("unstructuredConcurrencyTwoJoins");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    public void testForkFollowedByOnlyEndEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("forkFollowedByEndEvents");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    public void testNestedForksFollowedByEndEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedForksFollowedByEndEvents");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    public void testNestedForkJoin() {
        String pid = this.runtimeService.startProcessInstanceByKey("nestedForkJoin").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = query.list();
        ParallelGatewayTest.assertEquals((int)1, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Task 0", (String)((Task)tasks.get(0)).getName());
        ParallelGatewayTest.assertEquals((int)1, (int)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = query.list();
        ParallelGatewayTest.assertEquals((int)2, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Task A", (String)((Task)tasks.get(0)).getName());
        ParallelGatewayTest.assertEquals((String)"Task B", (String)((Task)tasks.get(1)).getName());
        ParallelGatewayTest.assertEquals((int)2, (int)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = query.list();
        ParallelGatewayTest.assertEquals((int)1, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Task B", (String)((Task)tasks.get(0)).getName());
        ParallelGatewayTest.assertEquals((int)2, (int)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = query.list();
        ParallelGatewayTest.assertEquals((int)2, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Task B1", (String)((Task)tasks.get(0)).getName());
        ParallelGatewayTest.assertEquals((String)"Task B2", (String)((Task)tasks.get(1)).getName());
        ParallelGatewayTest.assertEquals((int)3, (int)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = query.list();
        ParallelGatewayTest.assertEquals((int)1, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Task C", (String)((Task)tasks.get(0)).getName());
        ParallelGatewayTest.assertEquals((int)1, (int)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
    }

    @Deployment
    public void testReceyclingExecutionWithCallActivity() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("parent-process").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = query.list();
        ParallelGatewayTest.assertEquals((int)2, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Another task", (String)((Task)tasks.get(0)).getName());
        ParallelGatewayTest.assertEquals((String)"Some Task", (String)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = query.list();
        ParallelGatewayTest.assertEquals((int)1, (int)tasks.size());
        ParallelGatewayTest.assertEquals((String)"Another task", (String)((Task)tasks.get(0)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        ParallelGatewayTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    public void testCompletingJoin() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    public void testAsyncParallelGateway() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ParallelGatewayTest.assertNotNull((Object)jobDefinition);
        ParallelGatewayTest.assertEquals((String)"parallelJoinEnd", (String)jobDefinition.getActivityId());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ParallelGatewayTest.assertFalse((boolean)processInstance.isEnded());
        List list = this.managementService.createJobQuery().list();
        ParallelGatewayTest.assertEquals((int)2, (int)list.size());
        this.managementService.executeJob(((Job)list.get(0)).getId());
        this.managementService.executeJob(((Job)list.get(1)).getId());
        ParallelGatewayTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Deployment
    public void testAsyncParallelGatewayAfterScopeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ParallelGatewayTest.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        List list = this.managementService.createJobQuery().list();
        ParallelGatewayTest.assertEquals((int)2, (int)list.size());
        this.managementService.executeJob(((Job)list.get(0)).getId());
        this.managementService.executeJob(((Job)list.get(1)).getId());
        ParallelGatewayTest.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Deployment
    public void testCompletingJoinInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ParallelGatewayTest.assertTrue((boolean)processInstance.isEnded());
    }
}

