/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import java.util.List;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class UserTaskTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testTaskPropertiesNotNull() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        UserTaskTest.assertNotNull((Object)task.getId());
        UserTaskTest.assertEquals((String)"my task", (String)task.getName());
        UserTaskTest.assertEquals((String)"Very important", (String)task.getDescription());
        UserTaskTest.assertTrue((task.getPriority() > 0 ? 1 : 0) != 0);
        UserTaskTest.assertEquals((String)"kermit", (String)task.getAssignee());
        UserTaskTest.assertEquals((String)processInstance.getId(), (String)task.getProcessInstanceId());
        UserTaskTest.assertEquals((String)processInstance.getId(), (String)task.getExecutionId());
        UserTaskTest.assertNotNull((Object)task.getProcessDefinitionId());
        UserTaskTest.assertNotNull((Object)task.getTaskDefinitionKey());
        UserTaskTest.assertNotNull((Object)task.getCreateTime());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            UserTaskTest.assertEquals((int)0, (int)this.taskService.getTaskEvents(task.getId()).size());
        }
    }

    @Deployment
    public void testQuerySortingWithParameter() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        UserTaskTest.assertEquals((int)1, (int)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list().size());
    }

    @Deployment
    public void testCompleteAfterParallelGateway() throws InterruptedException {
        this.runtimeService.startProcessInstanceByKey("ForkProcess");
        List taskList = this.taskService.createTaskQuery().list();
        UserTaskTest.assertNotNull((Object)taskList);
        UserTaskTest.assertEquals((int)2, (int)taskList.size());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("SimpleUser").singleResult();
        UserTaskTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Deployment
    public void testComplexScenarioWithSubprocessesAndParallelGateways() {
        this.runtimeService.startProcessInstanceByKey("processWithSubProcessesAndParallelGateways");
        List taskList = this.taskService.createTaskQuery().list();
        UserTaskTest.assertNotNull((Object)taskList);
        UserTaskTest.assertEquals((int)13, (int)taskList.size());
    }
}

