/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.impl.instance.Body;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.junit.Assert;
import org.junit.Test;

public class CasePlanModelHandlerTest
extends CmmnElementHandlerTest {
    protected CasePlanModelHandler handler = new CasePlanModelHandler();

    @Test
    public void testCasePlanModelActivityName() {
        String name = "A CasePlanModel";
        this.casePlanModel.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testCasePlanModelActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"casePlanModel", (Object)activityType);
    }

    @Test
    public void testCasePlanModelDescription() {
        String description = "This is a casePlanModal";
        this.casePlanModel.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof StageActivityBehavior));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.casePlanModel.getExitCriterias().add(sentry);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(newActivity);
        SentryHandler sentryHandler = new SentryHandler();
        CmmnSentryDeclaration sentryDeclaration = sentryHandler.handleElement(sentry, this.context);
        this.handler.initializeExitCriterias(this.casePlanModel, newActivity, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
    }

    @Test
    public void testMultipleExitCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        this.casePlanModel.getExitCriterias().add(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        this.casePlanModel.getExitCriterias().add(sentry2);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(newActivity);
        SentryHandler sentryHandler = new SentryHandler();
        CmmnSentryDeclaration firstSentryDeclaration = sentryHandler.handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = sentryHandler.handleElement(sentry2, this.context);
        this.handler.initializeExitCriterias(this.casePlanModel, newActivity, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getExitCriteria().size());
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testAutoComplete() {
        this.casePlanModel.setAutoComplete(true);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.casePlanModel, this.context);
        Object autoComplete = newActivity.getProperty("autoComplete");
        Assert.assertNotNull((Object)autoComplete);
        Assert.assertTrue((boolean)((Boolean)autoComplete));
    }
}

