/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.HumanTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.CasePlanModelHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.HumanTaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.handler.SentryHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.task.listener.ClassDelegateTaskListener;
import org.camunda.bpm.engine.impl.task.listener.DelegateExpressionTaskListener;
import org.camunda.bpm.engine.impl.task.listener.ExpressionTaskListener;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.Body;
import org.camunda.bpm.model.cmmn.impl.instance.CaseRoles;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.impl.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.impl.instance.ItemControl;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.ExtensionElements;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.IfPart;
import org.camunda.bpm.model.cmmn.instance.ManualActivationRule;
import org.camunda.bpm.model.cmmn.instance.PlanItem;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.camunda.bpm.model.cmmn.instance.Role;
import org.camunda.bpm.model.cmmn.instance.Sentry;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaTaskListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HumanTaskPlanItemHandlerTest
extends CmmnElementHandlerTest {
    protected HumanTask humanTask;
    protected PlanItem planItem;
    protected HumanTaskItemHandler handler = new HumanTaskItemHandler();

    @Before
    public void setUp() {
        this.humanTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aHumanTask", HumanTask.class);
        this.planItem = this.createElement((CmmnModelElementInstance)this.casePlanModel, "PI_aHumanTask", PlanItem.class);
        this.planItem.setDefinition((PlanItemDefinition)this.humanTask);
    }

    @Test
    public void testHumanTaskActivityName() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testPlanItemActivityName() {
        String humanTaskName = "A HumanTask";
        this.humanTask.setName(humanTaskName);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNotEquals((Object)humanTaskName, (Object)activity.getName());
        Assert.assertEquals((Object)planItemName, (Object)activity.getName());
    }

    @Test
    public void testHumanTaskActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"humanTask", (Object)activityType);
    }

    @Test
    public void testHumanTaskDescriptionProperty() {
        String description = "This is a humanTask";
        this.humanTask.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testPlanItemDescriptionProperty() {
        String description = "This is a planItem";
        this.planItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof HumanTaskActivityBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.humanTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNull((Object)activity);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testTaskDecorator() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getTaskDecorator());
    }

    @Test
    public void testTaskDefinition() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        Assert.assertNotNull((Object)behavior.getTaskDefinition());
    }

    @Test
    public void testExpressionManager() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        ExpressionManager expressionManager = behavior.getExpressionManager();
        Assert.assertNotNull((Object)expressionManager);
        Assert.assertEquals((Object)this.context.getExpressionManager(), (Object)expressionManager);
    }

    @Test
    public void testTaskDefinitionHumanTaskNameExpression() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        Expression nameExpression = behavior.getTaskDefinition().getNameExpression();
        Assert.assertNotNull((Object)nameExpression);
        Assert.assertEquals((Object)"A HumanTask", (Object)nameExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionPlanItemNameExpression() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        String planItemName = "My LocalName";
        this.planItem.setName(planItemName);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression nameExpression = taskDefinition.getNameExpression();
        Assert.assertNotNull((Object)nameExpression);
        Assert.assertEquals((Object)"My LocalName", (Object)nameExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionDueDateExpression() {
        String aDueDate = "aDueDate";
        this.humanTask.setCamundaDueDate(aDueDate);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression dueDateExpression = taskDefinition.getDueDateExpression();
        Assert.assertNotNull((Object)dueDateExpression);
        Assert.assertEquals((Object)aDueDate, (Object)dueDateExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionFollowUpDateExpression() {
        String aFollowUpDate = "aFollowDate";
        this.humanTask.setCamundaFollowUpDate(aFollowUpDate);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression followUpDateExpression = taskDefinition.getFollowUpDateExpression();
        Assert.assertNotNull((Object)followUpDateExpression);
        Assert.assertEquals((Object)aFollowUpDate, (Object)followUpDateExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionPriorityExpression() {
        String aPriority = "aPriority";
        this.humanTask.setCamundaPriority(aPriority);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression priorityExpression = taskDefinition.getPriorityExpression();
        Assert.assertNotNull((Object)priorityExpression);
        Assert.assertEquals((Object)aPriority, (Object)priorityExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionPeformerExpression() {
        CaseRoles role = this.createElement((CmmnModelElementInstance)this.caseDefinition, "aRole", CaseRoles.class);
        role.setName("aPerformerRole");
        this.humanTask.setPerformer((Role)role);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression assigneeExpression = taskDefinition.getAssigneeExpression();
        Assert.assertNotNull((Object)assigneeExpression);
        Assert.assertEquals((Object)"aPerformerRole", (Object)assigneeExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionAssigneeExpression() {
        String aPriority = "aPriority";
        this.humanTask.setCamundaPriority(aPriority);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression priorityExpression = taskDefinition.getPriorityExpression();
        Assert.assertNotNull((Object)priorityExpression);
        Assert.assertEquals((Object)aPriority, (Object)priorityExpression.getExpressionText());
    }

    @Test
    public void testTaskDefinitionCandidateUsers() {
        String aCandidateUsers = "mary,john,peter";
        this.humanTask.setCamundaCandidateUsers(aCandidateUsers);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Set candidateUserExpressions = taskDefinition.getCandidateUserIdExpressions();
        Assert.assertEquals((long)3L, (long)candidateUserExpressions.size());
        for (Expression candidateUserExpression : candidateUserExpressions) {
            String candidateUser = candidateUserExpression.getExpressionText();
            if ("mary".equals(candidateUser)) {
                Assert.assertEquals((Object)"mary", (Object)candidateUser);
                continue;
            }
            if ("john".equals(candidateUser)) {
                Assert.assertEquals((Object)"john", (Object)candidateUser);
                continue;
            }
            if ("peter".equals(candidateUser)) {
                Assert.assertEquals((Object)"peter", (Object)candidateUser);
                continue;
            }
            Assert.fail((String)("Unexpected candidate user: " + candidateUser));
        }
    }

    @Test
    public void testTaskDefinitionCandidateGroups() {
        String aCandidateGroups = "accounting,management,backoffice";
        this.humanTask.setCamundaCandidateGroups(aCandidateGroups);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Set candidateGroupExpressions = taskDefinition.getCandidateGroupIdExpressions();
        Assert.assertEquals((long)3L, (long)candidateGroupExpressions.size());
        for (Expression candidateGroupExpression : candidateGroupExpressions) {
            String candidateGroup = candidateGroupExpression.getExpressionText();
            if ("accounting".equals(candidateGroup)) {
                Assert.assertEquals((Object)"accounting", (Object)candidateGroup);
                continue;
            }
            if ("management".equals(candidateGroup)) {
                Assert.assertEquals((Object)"management", (Object)candidateGroup);
                continue;
            }
            if ("backoffice".equals(candidateGroup)) {
                Assert.assertEquals((Object)"backoffice", (Object)candidateGroup);
                continue;
            }
            Assert.fail((String)("Unexpected candidate group: " + candidateGroup));
        }
    }

    @Test
    public void testTaskDefinitionFormKey() {
        String aFormKey = "aFormKey";
        this.humanTask.setCamundaFormKey(aFormKey);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression formKeyExpression = taskDefinition.getFormKey();
        Assert.assertNotNull((Object)formKeyExpression);
        Assert.assertEquals((Object)aFormKey, (Object)formKeyExpression.getExpressionText());
    }

    @Test
    public void testHumanTaskDescription() {
        String description = "A description";
        this.humanTask.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression descriptionExpression = taskDefinition.getDescriptionExpression();
        Assert.assertNotNull((Object)descriptionExpression);
        Assert.assertEquals((Object)description, (Object)descriptionExpression.getExpressionText());
    }

    @Test
    public void testPlanItemDescription() {
        String description = "A description";
        this.humanTask.setDescription(description);
        String localDescription = "My Local Description";
        this.planItem.setDescription(localDescription);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Expression descriptionExpression = taskDefinition.getDescriptionExpression();
        Assert.assertNotNull((Object)descriptionExpression);
        Assert.assertEquals((Object)localDescription, (Object)descriptionExpression.getExpressionText());
    }

    @Test
    public void testCreateTaskListenerByClass() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String className = "org.camunda.bpm.test.tasklistener.ABC";
        String event = "create";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaClass(className);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ClassDelegateTaskListener));
        ClassDelegateTaskListener classDelegateListener = (ClassDelegateTaskListener)listener;
        Assert.assertEquals((Object)className, (Object)classDelegateListener.getClassName());
        Assert.assertTrue((boolean)classDelegateListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testCreateTaskListenerByDelegateExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String delegateExpression = "${myDelegateExpression}";
        String event = "create";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaDelegateExpression(delegateExpression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof DelegateExpressionTaskListener));
        DelegateExpressionTaskListener delegateExpressionListener = (DelegateExpressionTaskListener)listener;
        Assert.assertEquals((Object)delegateExpression, (Object)delegateExpressionListener.getExpressionText());
        Assert.assertTrue((boolean)delegateExpressionListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testCreateTaskListenerByExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String expression = "${myExpression}";
        String event = "create";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaExpression(expression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ExpressionTaskListener));
        ExpressionTaskListener expressionListener = (ExpressionTaskListener)listener;
        Assert.assertEquals((Object)expression, (Object)expressionListener.getExpressionText());
    }

    @Test
    public void testCompleteTaskListenerByClass() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String className = "org.camunda.bpm.test.tasklistener.ABC";
        String event = "complete";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaClass(className);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ClassDelegateTaskListener));
        ClassDelegateTaskListener classDelegateListener = (ClassDelegateTaskListener)listener;
        Assert.assertEquals((Object)className, (Object)classDelegateListener.getClassName());
        Assert.assertTrue((boolean)classDelegateListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testCompleteTaskListenerByDelegateExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String delegateExpression = "${myDelegateExpression}";
        String event = "complete";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaDelegateExpression(delegateExpression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof DelegateExpressionTaskListener));
        DelegateExpressionTaskListener delegateExpressionListener = (DelegateExpressionTaskListener)listener;
        Assert.assertEquals((Object)delegateExpression, (Object)delegateExpressionListener.getExpressionText());
        Assert.assertTrue((boolean)delegateExpressionListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testCompleteTaskListenerByExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String expression = "${myExpression}";
        String event = "complete";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaExpression(expression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ExpressionTaskListener));
        ExpressionTaskListener expressionListener = (ExpressionTaskListener)listener;
        Assert.assertEquals((Object)expression, (Object)expressionListener.getExpressionText());
    }

    @Test
    public void testAssignmentTaskListenerByClass() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String className = "org.camunda.bpm.test.tasklistener.ABC";
        String event = "assignment";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaClass(className);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ClassDelegateTaskListener));
        ClassDelegateTaskListener classDelegateListener = (ClassDelegateTaskListener)listener;
        Assert.assertEquals((Object)className, (Object)classDelegateListener.getClassName());
        Assert.assertTrue((boolean)classDelegateListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testAssignmentTaskListenerByDelegateExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String delegateExpression = "${myDelegateExpression}";
        String event = "assignment";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaDelegateExpression(delegateExpression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof DelegateExpressionTaskListener));
        DelegateExpressionTaskListener delegateExpressionListener = (DelegateExpressionTaskListener)listener;
        Assert.assertEquals((Object)delegateExpression, (Object)delegateExpressionListener.getExpressionText());
        Assert.assertTrue((boolean)delegateExpressionListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testAssignmentTaskListenerByExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String expression = "${myExpression}";
        String event = "assignment";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaExpression(expression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ExpressionTaskListener));
        ExpressionTaskListener expressionListener = (ExpressionTaskListener)listener;
        Assert.assertEquals((Object)expression, (Object)expressionListener.getExpressionText());
    }

    @Test
    public void testDeleteTaskListenerByClass() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String className = "org.camunda.bpm.test.tasklistener.ABC";
        String event = "delete";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaClass(className);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ClassDelegateTaskListener));
        ClassDelegateTaskListener classDelegateListener = (ClassDelegateTaskListener)listener;
        Assert.assertEquals((Object)className, (Object)classDelegateListener.getClassName());
        Assert.assertTrue((boolean)classDelegateListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testDeleteTaskListenerByDelegateExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String delegateExpression = "${myDelegateExpression}";
        String event = "delete";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaDelegateExpression(delegateExpression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof DelegateExpressionTaskListener));
        DelegateExpressionTaskListener delegateExpressionListener = (DelegateExpressionTaskListener)listener;
        Assert.assertEquals((Object)delegateExpression, (Object)delegateExpressionListener.getExpressionText());
        Assert.assertTrue((boolean)delegateExpressionListener.getFieldDeclarations().isEmpty());
    }

    @Test
    public void testDeleteTaskListenerByExpression() {
        ExtensionElements extensionElements = this.addExtensionElements((CmmnModelElementInstance)this.humanTask);
        CamundaTaskListener taskListener = this.createElement((CmmnModelElementInstance)extensionElements, null, CamundaTaskListener.class);
        String expression = "${myExpression}";
        String event = "delete";
        taskListener.setCamundaEvent(event);
        taskListener.setCamundaExpression(expression);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertEquals((long)0L, (long)activity.getListeners().size());
        HumanTaskActivityBehavior behavior = (HumanTaskActivityBehavior)activity.getActivityBehavior();
        TaskDefinition taskDefinition = behavior.getTaskDefinition();
        Assert.assertNotNull((Object)taskDefinition);
        Assert.assertEquals((long)1L, (long)taskDefinition.getTaskListeners().size());
        List createListeners = taskDefinition.getTaskListener(event);
        Assert.assertEquals((long)1L, (long)createListeners.size());
        TaskListener listener = (TaskListener)createListeners.get(0);
        Assert.assertTrue((boolean)(listener instanceof ExpressionTaskListener));
        ExpressionTaskListener expressionListener = (ExpressionTaskListener)listener;
        Assert.assertEquals((Object)expression, (Object)expressionListener.getExpressionText());
    }

    @Test
    public void testExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.planItem.getExitCriterias().add(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
    }

    @Test
    public void testMultipleExitCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        this.planItem.getExitCriterias().add(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        this.planItem.getExitCriterias().add(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getExitCriteria().size());
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getExitCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testMultipleEntryCriteria() {
        Sentry sentry1 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart1 = this.createElement((CmmnModelElementInstance)sentry1, "abc", IfPart.class);
        ConditionExpression conditionExpression1 = this.createElement((CmmnModelElementInstance)ifPart1, "def", ConditionExpression.class);
        Body body1 = this.createElement((CmmnModelElementInstance)conditionExpression1, null, Body.class);
        body1.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry1);
        Sentry sentry2 = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_2", Sentry.class);
        IfPart ifPart2 = this.createElement((CmmnModelElementInstance)sentry2, "ghi", IfPart.class);
        ConditionExpression conditionExpression2 = this.createElement((CmmnModelElementInstance)ifPart2, "jkl", ConditionExpression.class);
        Body body2 = this.createElement((CmmnModelElementInstance)conditionExpression2, null, Body.class);
        body2.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry2);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration firstSentryDeclaration = new SentryHandler().handleElement(sentry1, this.context);
        CmmnSentryDeclaration secondSentryDeclaration = new SentryHandler().handleElement(sentry2, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertTrue((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)2L, (long)newActivity.getEntryCriteria().size());
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(firstSentryDeclaration));
        Assert.assertTrue((boolean)newActivity.getEntryCriteria().contains(secondSentryDeclaration));
    }

    @Test
    public void testEntryCriteriaAndExitCriteria() {
        Sentry sentry = this.createElement((CmmnModelElementInstance)this.casePlanModel, "Sentry_1", Sentry.class);
        IfPart ifPart = this.createElement((CmmnModelElementInstance)sentry, "abc", IfPart.class);
        ConditionExpression conditionExpression = this.createElement((CmmnModelElementInstance)ifPart, "def", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)conditionExpression, null, Body.class);
        body.setTextContent("${test}");
        this.planItem.getEntryCriterias().add(sentry);
        this.planItem.getExitCriterias().add(sentry);
        CmmnActivity parent = new CasePlanModelHandler().handleElement((CmmnElement)this.casePlanModel, this.context);
        this.context.setParent(parent);
        CmmnSentryDeclaration sentryDeclaration = new SentryHandler().handleElement(sentry, this.context);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Assert.assertFalse((boolean)newActivity.getExitCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getExitCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getExitCriteria().get(0));
        Assert.assertFalse((boolean)newActivity.getEntryCriteria().isEmpty());
        Assert.assertEquals((long)1L, (long)newActivity.getEntryCriteria().size());
        Assert.assertEquals((Object)sentryDeclaration, newActivity.getEntryCriteria().get(0));
    }

    @Test
    public void testManualActivationRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)itemControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testManualActivationRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.humanTask, "ItemControl_1", DefaultControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)defaultControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.planItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.humanTask, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.planItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }
}

