/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.MilestoneActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.MilestoneItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.Body;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.impl.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.impl.instance.ItemControl;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.DiscretionaryItem;
import org.camunda.bpm.model.cmmn.instance.Milestone;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanningTable;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MilestoneDiscretionaryItemHandlerTest
extends CmmnElementHandlerTest {
    protected Milestone milestone;
    protected PlanningTable planningTable;
    protected DiscretionaryItem discretionaryItem;
    protected MilestoneItemHandler handler = new MilestoneItemHandler();

    @Before
    public void setUp() {
        this.milestone = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aMilestone", Milestone.class);
        this.planningTable = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aPlanningTable", PlanningTable.class);
        this.discretionaryItem = this.createElement((CmmnModelElementInstance)this.planningTable, "DI_aMilestone", DiscretionaryItem.class);
        this.discretionaryItem.setDefinition((PlanItemDefinition)this.milestone);
    }

    @Test
    public void testMilestoneActivityName() {
        String name = "A Milestone";
        this.milestone.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testMilestoneActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"milestone", (Object)activityType);
    }

    @Test
    public void testMilestoneDescription() {
        String description = "This is a milestone";
        this.milestone.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testDiscretionaryItemDescription() {
        String description = "This is a discretionaryItem";
        this.discretionaryItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof MilestoneActivityBehavior));
    }

    @Test
    public void testIsDiscretionaryProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Boolean discretionary = (Boolean)activity.getProperty("discretionary");
        Assert.assertTrue((boolean)discretionary);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.discretionaryItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.milestone, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }
}

