/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.StageItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.Body;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.impl.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.impl.instance.ItemControl;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.DiscretionaryItem;
import org.camunda.bpm.model.cmmn.instance.ManualActivationRule;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanningTable;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.camunda.bpm.model.cmmn.instance.Stage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StageDiscretionaryItemHandlerTest
extends CmmnElementHandlerTest {
    protected Stage stage;
    protected PlanningTable planningTable;
    protected DiscretionaryItem discretionaryItem;
    protected StageItemHandler handler = new StageItemHandler();

    @Before
    public void setUp() {
        this.stage = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aStage", Stage.class);
        this.planningTable = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aPlanningTable", PlanningTable.class);
        this.discretionaryItem = this.createElement((CmmnModelElementInstance)this.planningTable, "DI_aStage", DiscretionaryItem.class);
        this.discretionaryItem.setDefinition((PlanItemDefinition)this.stage);
    }

    @Test
    public void testStageActivityName() {
        String name = "A Stage";
        this.stage.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testStageActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"stage", (Object)activityType);
    }

    @Test
    public void testStageDescription() {
        String description = "This is a stage";
        this.stage.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testDiscretionaryItemDescription() {
        String description = "This is a discretionaryItem";
        this.discretionaryItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof StageActivityBehavior));
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testManualActivationRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.discretionaryItem, "ItemControl_1", ItemControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)itemControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testManualActivationRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.stage, "ItemControl_1", DefaultControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)defaultControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.discretionaryItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.stage, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testAutoComplete() {
        this.stage.setAutoComplete(true);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object autoComplete = newActivity.getProperty("autoComplete");
        Assert.assertNotNull((Object)autoComplete);
        Assert.assertTrue((boolean)((Boolean)autoComplete));
    }
}

