/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;

public class CaseExecutionStateTransitionCollector
implements CaseExecutionListener {
    private static Logger log = Logger.getLogger(CaseExecutionStateTransitionCollector.class.getName());
    public List<String> stateTransitions = new ArrayList<String>();

    public void notify(DelegateCaseExecution planItem) throws Exception {
        CmmnExecution execution = (CmmnExecution)planItem;
        String activityId = execution.getEventSource().getId();
        CaseExecutionState previousState = execution.getPreviousState();
        String previousStateName = "()";
        if (!previousState.equals(CaseExecutionState.NEW)) {
            previousStateName = previousState.toString();
        }
        CaseExecutionState newState = execution.getCurrentState();
        String stateTransition = previousStateName + " --" + execution.getEventName() + "(" + activityId + ")--> " + newState;
        log.fine("collecting state transition: " + stateTransition);
        this.stateTransitions.add(stateTransition);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (String event : this.stateTransitions) {
            text.append(event);
            text.append("\n");
        }
        return text.toString();
    }
}

