/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.junit.Ignore;

@Ignore
public class CompetingForkTest
extends PluggableProcessEngineTestCase {
    private static Logger log = Logger.getLogger(CompetingForkTest.class.getName());
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;
    static String jobId;

    @Deployment
    public void FAILING_testCompetingFork() throws Exception {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        String task1 = ((Task)query.taskDefinitionKey("task1").singleResult()).getId();
        String task2 = ((Task)query.taskDefinitionKey("task2").singleResult()).getId();
        String task3 = ((Task)query.taskDefinitionKey("task3").singleResult()).getId();
        log.fine("test thread starts thread one");
        CompleteTaskThread threadOne = new CompleteTaskThread(task1);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread thread two");
        CompleteTaskThread threadTwo = new CompleteTaskThread(task2);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread three");
        CompleteTaskThread threadThree = new CompleteTaskThread(task3);
        threadThree.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingForkTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingForkTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
        log.fine("test thread notifies thread 3");
        threadThree.proceedAndWaitTillDone();
        CompetingForkTest.assertNotNull((Object)((Object)threadThree.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadThree.exception.getMessage());
    }

    public class CompleteTaskThread
    extends ControllableThread {
        String taskId;
        OptimisticLockingException exception;

        public CompleteTaskThread(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingForkTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)new CompleteTaskCmd(this.taskId, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

