/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmmn.cmd.CompleteCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.DisableCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.StateTransitionCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class CompetingParentCompletionTest
extends PluggableProcessEngineTestCase {
    private static Logger log = Logger.getLogger(CompetingParentCompletionTest.class.getName());
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingParentCompletionTest.testComplete.cmmn"})
    public void testComplete() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        CompletionSingleThread threadOne = new CompletionSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingParentCompletionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingParentCompletionTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingParentCompletionTest.testDisable.cmmn"})
    public void testDisable() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        DisableSingleThread threadOne = new DisableSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        DisableSingleThread threadTwo = new DisableSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingParentCompletionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingParentCompletionTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingParentCompletionTest.testTerminate.cmmn"})
    public void testTerminate() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        TerminateSingleThread threadOne = new TerminateSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        TerminateSingleThread threadTwo = new TerminateSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingParentCompletionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingParentCompletionTest.assertNotNull((Object)((Object)threadTwo.exception));
        this.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    public class TerminateSingleThread
    extends SingleThread {
        public TerminateSingleThread(String caseExecutionId) {
            super(caseExecutionId, new StateTransitionCaseExecutionCmd(caseExecutionId, null, null, null, null){
                private static final long serialVersionUID = 1L;

                protected void performStateTransition(CommandContext commandContext, CaseExecutionEntity caseExecution) {
                    caseExecution.terminate();
                }
            });
        }
    }

    public class DisableSingleThread
    extends SingleThread {
        public DisableSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new DisableCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public class CompletionSingleThread
    extends SingleThread {
        public CompletionSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new CompleteCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public abstract class SingleThread
    extends ControllableThread {
        String caseExecutionId;
        OptimisticLockingException exception;
        protected StateTransitionCaseExecutionCmd cmd;

        public SingleThread(String caseExecutionId, StateTransitionCaseExecutionCmd cmd) {
            this.caseExecutionId = caseExecutionId;
            this.cmd = cmd;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingParentCompletionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)this.cmd));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

