/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.logging.Logger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmmn.cmd.CompleteCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.ManualStartCaseExecutionCmd;
import org.camunda.bpm.engine.impl.cmmn.cmd.StateTransitionCaseExecutionCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;

public class CompetingSentrySatisfactionTest
extends PluggableProcessEngineTestCase {
    private static Logger log = Logger.getLogger(CompetingSentrySatisfactionTest.class.getName());
    Thread testThread = Thread.currentThread();
    static ControllableThread activeThread;

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testEntryCriteriaWithAndSentry.cmmn"})
    public void testEntryCriteriaWithAndSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.assertTextPresent("CaseSentryPartEntity", message);
        this.assertTextPresent("was updated by another transaction concurrently", message);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testExitCriteriaWithAndSentry.cmmn"})
    public void testExitCriteriaWithAndSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.assertTextPresent("CaseSentryPartEntity", message);
        this.assertTextPresent("was updated by another transaction concurrently", message);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testEntryCriteriaWithOrSentry.cmmn"})
    public void testEntryCriteriaWithOrSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.assertTextPresent("CaseExecutionEntity", message);
        this.assertTextPresent("was updated by another transaction concurrently", message);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingSentrySatisfactionTest.testExitCriteriaWithOrSentry.cmmn"})
    public void testExitCriteriaWithOrSentry() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String firstHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_1").singleResult()).getId();
        String secondHumanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(caseInstanceId).activityId("PI_HumanTask_2").singleResult()).getId();
        log.fine("test thread starts thread one");
        ManualStartSingleThread threadOne = new ManualStartSingleThread(firstHumanTaskId);
        threadOne.startAndWaitUntilControlIsReturned();
        log.fine("test thread continues to start thread two");
        CompletionSingleThread threadTwo = new CompletionSingleThread(secondHumanTaskId);
        threadTwo.startAndWaitUntilControlIsReturned();
        log.fine("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNull((Object)((Object)threadOne.exception));
        log.fine("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        CompetingSentrySatisfactionTest.assertNotNull((Object)((Object)threadTwo.exception));
        String message = threadTwo.exception.getMessage();
        this.assertTextPresent("CaseExecutionEntity", message);
        this.assertTextPresent("was updated by another transaction concurrently", message);
    }

    public class ManualStartSingleThread
    extends SingleThread {
        public ManualStartSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new ManualStartCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public class CompletionSingleThread
    extends SingleThread {
        public CompletionSingleThread(String caseExecutionId) {
            super(caseExecutionId, (StateTransitionCaseExecutionCmd)new CompleteCaseExecutionCmd(caseExecutionId, null, null, null, null));
        }
    }

    public abstract class SingleThread
    extends ControllableThread {
        String caseExecutionId;
        OptimisticLockingException exception;
        protected StateTransitionCaseExecutionCmd cmd;

        public SingleThread(String caseExecutionId, StateTransitionCaseExecutionCmd cmd) {
            this.caseExecutionId = caseExecutionId;
            this.cmd = cmd;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSentrySatisfactionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new ControlledCommand(activeThread, (Command<?>)this.cmd));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            log.fine(this.getName() + " ends");
        }
    }
}

