/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.camunda.bpm.engine.impl.cmd.DeployCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class ConcurrentDeploymentTest
extends ConcurrencyTestCase {
    private static String processResource;

    public void testDuplicateFiltering() throws InterruptedException {
        if ("h2".equals(this.processEngineConfiguration.getDbSqlSessionFactory().getDatabaseType())) {
            return;
        }
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableDeployCommand());
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableDeployCommand());
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        ConcurrentDeploymentTest.assertEquals((long)1L, (long)deploymentQuery.count());
        Deployment deployment = (Deployment)deploymentQuery.singleResult();
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    static {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess().startEvent().done();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outputStream, (BpmnModelInstance)modelInstance);
        processResource = new String(outputStream.toByteArray());
    }

    protected static class ControllableDeployCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected ControllableDeployCommand() {
        }

        public Void execute(CommandContext commandContext) {
            DeploymentBuilder deploymentBuilder = new DeploymentBuilderImpl(null).name("some-deployment-name").enableDuplicateFiltering(false).addString("foo.bpmn", processResource);
            this.monitor.sync();
            new DeployCmd((DeploymentBuilderImpl)deploymentBuilder).execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

