/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.Deployment;

public class DeploymentPersistenceTest
extends PluggableProcessEngineTestCase {
    public void testDeploymentPersistence() {
        Deployment deployment = this.repositoryService.createDeployment().name("strings").addString("org/camunda/bpm/engine/test/test/HelloWorld.string", "hello world").addString("org/camunda/bpm/engine/test/test/TheAnswer.string", "42").deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        DeploymentPersistenceTest.assertEquals((int)1, (int)deployments.size());
        deployment = (Deployment)deployments.get(0);
        DeploymentPersistenceTest.assertEquals((String)"strings", (String)deployment.getName());
        DeploymentPersistenceTest.assertNotNull((Object)deployment.getDeploymentTime());
        String deploymentId = deployment.getId();
        List resourceNames = this.repositoryService.getDeploymentResourceNames(deploymentId);
        HashSet<String> expectedResourceNames = new HashSet<String>();
        expectedResourceNames.add("org/camunda/bpm/engine/test/test/HelloWorld.string");
        expectedResourceNames.add("org/camunda/bpm/engine/test/test/TheAnswer.string");
        DeploymentPersistenceTest.assertEquals(expectedResourceNames, new HashSet(resourceNames));
        InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, "org/camunda/bpm/engine/test/test/HelloWorld.string");
        DeploymentPersistenceTest.assertTrue((boolean)Arrays.equals("hello world".getBytes(), IoUtil.readInputStream((InputStream)resourceStream, (String)"test")));
        resourceStream = this.repositoryService.getResourceAsStream(deploymentId, "org/camunda/bpm/engine/test/test/TheAnswer.string");
        DeploymentPersistenceTest.assertTrue((boolean)Arrays.equals("42".getBytes(), IoUtil.readInputStream((InputStream)resourceStream, (String)"test")));
        this.repositoryService.deleteDeployment(deploymentId);
    }
}

