/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;

public class ProcessDefinitionPersistenceTest
extends PluggableProcessEngineTestCase {
    public void testProcessDefinitionPersistence() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/db/processOne.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/db/processTwo.bpmn20.xml").deploy().getId();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        ProcessDefinitionPersistenceTest.assertEquals((int)2, (int)processDefinitions.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testProcessDefinitionIntrospection() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/db/processOne.bpmn20.xml").deploy().getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(procDefId);
        ProcessDefinitionPersistenceTest.assertEquals((String)procDefId, (String)processDefinition.getId());
        ProcessDefinitionPersistenceTest.assertEquals((String)"Process One", (String)processDefinition.getName());
        ProcessDefinitionPersistenceTest.assertEquals((Object)"the first process", (Object)processDefinition.getProperty("documentation"));
        PvmActivity start = processDefinition.findActivity("start");
        ProcessDefinitionPersistenceTest.assertNotNull((Object)start);
        ProcessDefinitionPersistenceTest.assertEquals((String)"start", (String)start.getId());
        ProcessDefinitionPersistenceTest.assertEquals((Object)"S t a r t", (Object)start.getProperty("name"));
        ProcessDefinitionPersistenceTest.assertEquals((Object)"the start event", (Object)start.getProperty("documentation"));
        ProcessDefinitionPersistenceTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)start.getActivities());
        List outgoingTransitions = start.getOutgoingTransitions();
        ProcessDefinitionPersistenceTest.assertEquals((int)1, (int)outgoingTransitions.size());
        ProcessDefinitionPersistenceTest.assertEquals((Object)"${a == b}", (Object)((PvmTransition)outgoingTransitions.get(0)).getProperty("conditionText"));
        PvmActivity end = processDefinition.findActivity("end");
        ProcessDefinitionPersistenceTest.assertNotNull((Object)end);
        ProcessDefinitionPersistenceTest.assertEquals((String)"end", (String)end.getId());
        PvmTransition transition = (PvmTransition)outgoingTransitions.get(0);
        ProcessDefinitionPersistenceTest.assertEquals((String)"flow1", (String)transition.getId());
        ProcessDefinitionPersistenceTest.assertEquals((Object)"Flow One", (Object)transition.getProperty("name"));
        ProcessDefinitionPersistenceTest.assertEquals((Object)"The only transitions in the process", (Object)transition.getProperty("documentation"));
        ProcessDefinitionPersistenceTest.assertSame((Object)start, (Object)transition.getSource());
        ProcessDefinitionPersistenceTest.assertSame((Object)end, (Object)transition.getDestination());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testProcessDefinitionQuery() {
        String deployment1Id = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/db/processOne.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/db/processTwo.bpmn20.xml").deploy().getId();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).list();
        ProcessDefinitionPersistenceTest.assertEquals((int)2, (int)processDefinitions.size());
        String deployment2Id = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/db/processOne.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/db/processTwo.bpmn20.xml").deploy().getId();
        ProcessDefinitionPersistenceTest.assertEquals((long)4L, (long)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).count());
        ProcessDefinitionPersistenceTest.assertEquals((long)2L, (long)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionName().asc()).count());
        this.repositoryService.deleteDeployment(deployment1Id);
        this.repositoryService.deleteDeployment(deployment2Id);
    }
}

