/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class VariableScopeTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testVariableScope() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("test", "test");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess", varMap);
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        VariableScopeTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        VariableScopeTest.assertEquals((Object)"test2", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        VariableScopeTest.assertEquals((Object)"test2", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        VariableScopeTest.assertEquals((Object)"test", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        VariableScopeTest.assertEquals((Object)"test", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.runtimeService.setVariableLocal(subProcessTask.getExecutionId(), "test", (Object)"test3");
        VariableScopeTest.assertEquals((Object)"test3", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        VariableScopeTest.assertEquals((Object)"test3", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        VariableScopeTest.assertEquals((Object)"test", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        VariableScopeTest.assertEquals((Object)"test", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.runtimeService.setVariable(pi.getId(), "test", (Object)"test4");
        VariableScopeTest.assertEquals((Object)"test3", (Object)this.runtimeService.getVariable(subProcessTask.getExecutionId(), "test"));
        VariableScopeTest.assertEquals((Object)"test3", this.runtimeService.getVariables(subProcessTask.getExecutionId()).get("test"));
        VariableScopeTest.assertEquals((Object)"test4", (Object)this.runtimeService.getVariable(pi.getId(), "test"));
        VariableScopeTest.assertEquals((Object)"test4", this.runtimeService.getVariables(pi.getId()).get("test"));
        this.taskService.complete(subProcessTask.getId());
    }

    @Deployment
    public void testVariableNamesScope() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("test", "test");
        varMap.put("helloWorld", "helloWorld");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("simpleSubProcess", varMap);
        Task subProcessTask = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        this.runtimeService.setVariableLocal(pi.getProcessInstanceId(), "mainProcessLocalVariable", (Object)"Hello World");
        VariableScopeTest.assertEquals((String)"Task in subprocess", (String)subProcessTask.getName());
        this.runtimeService.setVariableLocal(subProcessTask.getExecutionId(), "subProcessLocalVariable", (Object)"Hello SubProcess");
        List result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(pi.getProcessInstanceId(), true));
        VariableScopeTest.assertTrue((boolean)result.contains("test"));
        VariableScopeTest.assertTrue((boolean)result.contains("helloWorld"));
        VariableScopeTest.assertTrue((boolean)result.contains("mainProcessLocalVariable"));
        VariableScopeTest.assertFalse((boolean)result.contains("subProcessLocalVariable"));
        result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(pi.getProcessInstanceId(), false));
        VariableScopeTest.assertTrue((boolean)result.contains("test"));
        VariableScopeTest.assertTrue((boolean)result.contains("mainProcessLocalVariable"));
        VariableScopeTest.assertTrue((boolean)result.contains("helloWorld"));
        VariableScopeTest.assertFalse((boolean)result.contains("subProcessLocalVariable"));
        result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(subProcessTask.getExecutionId(), true));
        VariableScopeTest.assertTrue((boolean)result.contains("test"));
        VariableScopeTest.assertTrue((boolean)result.contains("subProcessLocalVariable"));
        VariableScopeTest.assertFalse((boolean)result.contains("helloWorld"));
        VariableScopeTest.assertFalse((boolean)result.contains("mainProcessLocalVariable"));
        result = (List)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetVariableNamesCommand(subProcessTask.getExecutionId(), false));
        VariableScopeTest.assertTrue((boolean)result.contains("test"));
        VariableScopeTest.assertTrue((boolean)result.contains("subProcessLocalVariable"));
        VariableScopeTest.assertTrue((boolean)result.contains("helloWorld"));
        VariableScopeTest.assertTrue((boolean)result.contains("mainProcessLocalVariable"));
        this.taskService.complete(subProcessTask.getId());
    }

    private class GetVariableNamesCommand
    implements Command<List<String>> {
        private String executionId;
        private boolean isLocal;

        public GetVariableNamesCommand(String executionId, boolean isLocal) {
            this.executionId = executionId;
            this.isLocal = isLocal;
        }

        public List<String> execute(CommandContext commandContext) {
            EnsureUtil.ensureNotNull((String)"executionId", (Object)this.executionId);
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
            EnsureUtil.ensureNotNull((String)("execution " + this.executionId + " doesn't exist"), (String)"execution", (Object)execution);
            ArrayList<String> executionVariables = this.isLocal ? new ArrayList<String>(execution.getVariableNamesLocal()) : new ArrayList(execution.getVariableNames());
            return executionVariables;
        }
    }
}

