/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.JobExceptionUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.FirstFailingDelegate;
import org.camunda.bpm.engine.test.history.SecondFailingDelegate;
import org.camunda.bpm.engine.test.history.ThrowExceptionWithoutMessageDelegate;
import org.camunda.bpm.engine.variable.Variables;

public class HistoricJobLogTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testCreateHistoricJobLogProperties() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().creationLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNotNull((Object)historicJob.getTimestamp());
        HistoricJobLogTest.assertNull((Object)historicJob.getJobExceptionMessage());
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"serviceTask", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"async-continuation", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"async-before", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((int)job.getRetries(), (int)historicJob.getJobRetries());
        HistoricJobLogTest.assertEquals((String)job.getExecutionId(), (String)historicJob.getExecutionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessInstanceId(), (String)historicJob.getProcessInstanceId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionId(), (String)historicJob.getProcessDefinitionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionKey(), (String)historicJob.getProcessDefinitionKey());
        HistoricJobLogTest.assertEquals((String)job.getDeploymentId(), (String)historicJob.getDeploymentId());
        HistoricJobLogTest.assertTrue((boolean)historicJob.isCreationLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isFailureLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isSuccessLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isDeletionLog());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testFailedHistoricJobLogProperties() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNotNull((Object)historicJob.getTimestamp());
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"serviceTask", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"async-continuation", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"async-before", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((int)3, (int)historicJob.getJobRetries());
        HistoricJobLogTest.assertEquals((String)job.getExecutionId(), (String)historicJob.getExecutionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessInstanceId(), (String)historicJob.getProcessInstanceId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionId(), (String)historicJob.getProcessDefinitionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionKey(), (String)historicJob.getProcessDefinitionKey());
        HistoricJobLogTest.assertEquals((String)job.getDeploymentId(), (String)historicJob.getDeploymentId());
        HistoricJobLogTest.assertEquals((String)"Expected exception.", (String)historicJob.getJobExceptionMessage());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isCreationLog());
        HistoricJobLogTest.assertTrue((boolean)historicJob.isFailureLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isSuccessLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isDeletionLog());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testSuccessfulHistoricJobLogProperties() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().successLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNotNull((Object)historicJob.getTimestamp());
        HistoricJobLogTest.assertNull((Object)historicJob.getJobExceptionMessage());
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"serviceTask", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"async-continuation", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"async-before", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((int)job.getRetries(), (int)historicJob.getJobRetries());
        HistoricJobLogTest.assertEquals((String)job.getExecutionId(), (String)historicJob.getExecutionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessInstanceId(), (String)historicJob.getProcessInstanceId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionId(), (String)historicJob.getProcessDefinitionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionKey(), (String)historicJob.getProcessDefinitionKey());
        HistoricJobLogTest.assertEquals((String)job.getDeploymentId(), (String)historicJob.getDeploymentId());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isCreationLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isFailureLog());
        HistoricJobLogTest.assertTrue((boolean)historicJob.isSuccessLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isDeletionLog());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testDeletedHistoricJobLogProperties() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().deletionLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNotNull((Object)historicJob.getTimestamp());
        HistoricJobLogTest.assertNull((Object)historicJob.getJobExceptionMessage());
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"serviceTask", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"async-continuation", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"async-before", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((int)job.getRetries(), (int)historicJob.getJobRetries());
        HistoricJobLogTest.assertEquals((String)job.getExecutionId(), (String)historicJob.getExecutionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessInstanceId(), (String)historicJob.getProcessInstanceId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionId(), (String)historicJob.getProcessDefinitionId());
        HistoricJobLogTest.assertEquals((String)job.getProcessDefinitionKey(), (String)historicJob.getProcessDefinitionKey());
        HistoricJobLogTest.assertEquals((String)job.getDeploymentId(), (String)historicJob.getDeploymentId());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isCreationLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isFailureLog());
        HistoricJobLogTest.assertFalse((boolean)historicJob.isSuccessLog());
        HistoricJobLogTest.assertTrue((boolean)historicJob.isDeletionLog());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testAsyncBeforeJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNull((Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"serviceTask", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"async-continuation", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"async-before", (String)historicJob.getJobDefinitionConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testAsyncAfterJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        Job anotherJob = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLogTest.assertFalse((boolean)job.getId().equals(anotherJob.getId()));
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(anotherJob.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNull((Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((String)anotherJob.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"serviceTask", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"async-continuation", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"async-after", (String)historicJob.getJobDefinitionConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testStartTimerEvent.bpmn20.xml"})
    public void testStartTimerEventJobHandlerType() {
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"theStart", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"timer-start-event", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"CYCLE: 0 0/5 * * * ?", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testStartTimerEventInsideEventSubProcess.bpmn20.xml"})
    public void testStartTimerEventInsideEventSubProcessJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"subprocessStartEvent", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"timer-start-event-subprocess", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"DURATION: PT1M", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testIntermediateTimerEvent.bpmn20.xml"})
    public void testIntermediateTimerEventJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"timer", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"timer-intermediate-transition", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"DURATION: PT1M", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testBoundaryTimerEvent.bpmn20.xml"})
    public void testBoundaryTimerEventJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"timer", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"timer-transition", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertEquals((String)"DURATION: PT5M", (String)historicJob.getJobDefinitionConfiguration());
        HistoricJobLogTest.assertEquals((Object)job.getDuedate(), (Object)historicJob.getJobDueDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testCatchingSignalEvent.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricJobLogTest.testThrowingSignalEventAsync.bpmn20.xml"})
    public void testCatchingSignalEventJobHandlerType() {
        this.runtimeService.startProcessInstanceByKey("catchSignal");
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(job.getId()).singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertNull((Object)historicJob.getJobDueDate());
        HistoricJobLogTest.assertEquals((String)job.getId(), (String)historicJob.getJobId());
        HistoricJobLogTest.assertEquals((String)job.getJobDefinitionId(), (String)historicJob.getJobDefinitionId());
        HistoricJobLogTest.assertEquals((String)"signalEvent", (String)historicJob.getActivityId());
        HistoricJobLogTest.assertEquals((String)"event", (String)historicJob.getJobDefinitionType());
        HistoricJobLogTest.assertNull((Object)historicJob.getJobDefinitionConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testCatchingSignalEvent.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricJobLogTest.testThrowingSignalEventAsync.bpmn20.xml"})
    public void testCatchingSignalEventActivityId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchSignal").getId();
        this.runtimeService.startProcessInstanceByKey("throwSignal");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLog historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)"signalEvent", (String)historicJob.getActivityId());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)"signalEvent", (String)historicJob.getActivityId());
        this.runtimeService.setVariable(processInstanceId, "fail", (Object)false);
        this.managementService.executeJob(jobId);
        historicJob = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog().singleResult();
        HistoricJobLogTest.assertNotNull((Object)historicJob);
        HistoricJobLogTest.assertEquals((String)"signalEvent", (String)historicJob.getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testFailedJobEvents() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery failedQuery = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().orderByJobRetries().desc();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)failedQuery.count());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)failedQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog failedJobLogEntry = (HistoricJobLog)failedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)3L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)2L, (long)failedQuery.count());
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)4L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)3L, (long)failedQuery.count());
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        HistoricJobLogTest.assertEquals((int)1, (int)failedJobLogEntry.getJobRetries());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)5L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)4L, (long)failedQuery.count());
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        HistoricJobLogTest.assertEquals((int)1, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(3);
        HistoricJobLogTest.assertEquals((int)0, (int)failedJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testFailedJobEventsExecutedByJobExecutor() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery failedQuery = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().orderByJobRetries().desc();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)failedQuery.count());
        this.executeAvailableJobs();
        HistoricJobLogTest.assertEquals((long)4L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)3L, (long)failedQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        HistoricJobLogTest.assertEquals((int)1, (int)failedJobLogEntry.getJobRetries());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)5L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)4L, (long)failedQuery.count());
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(2);
        HistoricJobLogTest.assertEquals((int)1, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(3);
        HistoricJobLogTest.assertEquals((int)0, (int)failedJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testSuccessfulJobEvent() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery succeededQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)succeededQuery.count());
        this.managementService.executeJob(jobId);
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)succeededQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog succeededJobLogEntry = (HistoricJobLog)succeededQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)succeededJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testSuccessfulJobEventExecutedByJobExecutor() {
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)false));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery succeededQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)succeededQuery.count());
        this.executeAvailableJobs();
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)succeededQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog succeededJobLogEntry = (HistoricJobLog)succeededQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)succeededJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testSuccessfulAndFailedJobEvents() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery failedQuery = (HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().jobId(jobId).failureLog().orderByJobRetries().desc();
        HistoricJobLogQuery succeededQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)failedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)succeededQuery.count());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)failedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)succeededQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog failedJobLogEntry = (HistoricJobLog)failedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLogTest.assertEquals((long)3L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)2L, (long)failedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)succeededQuery.count());
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        this.runtimeService.setVariable(processInstanceId, "fail", (Object)false);
        this.managementService.executeJob(jobId);
        HistoricJobLogTest.assertEquals((long)4L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)2L, (long)failedQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)succeededQuery.count());
        createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(0);
        HistoricJobLogTest.assertEquals((int)3, (int)failedJobLogEntry.getJobRetries());
        failedJobLogEntry = (HistoricJobLog)failedQuery.list().get(1);
        HistoricJobLogTest.assertEquals((int)2, (int)failedJobLogEntry.getJobRetries());
        HistoricJobLog succeededJobLogEntry = (HistoricJobLog)succeededQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)1, (int)succeededJobLogEntry.getJobRetries());
    }

    @Deployment
    public void testTerminateEndEvent() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String serviceTask1JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask1").singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogQuery serviceTask1Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId);
        HistoricJobLogQuery serviceTask1CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).creationLog();
        HistoricJobLogQuery serviceTask1DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).deletionLog();
        HistoricJobLogQuery serviceTask1SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask1DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask1SuccessfulQuery.count());
        String serviceTask2JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask2").singleResult()).getId();
        HistoricJobLogQuery serviceTask2Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId);
        HistoricJobLogQuery serviceTask2CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).creationLog();
        HistoricJobLogQuery serviceTask2DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).deletionLog();
        HistoricJobLogQuery serviceTask2SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask2DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask2SuccessfulQuery.count());
        this.managementService.executeJob(serviceTask1JobId);
        HistoricJobLogTest.assertEquals((long)4L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)2L, (long)serviceTask1Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask1DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1SuccessfulQuery.count());
        HistoricJobLog serviceTask1CreatedJobLogEntry = (HistoricJobLog)serviceTask1CreatedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask1CreatedJobLogEntry.getJobRetries());
        HistoricJobLog serviceTask1SuccessfulJobLogEntry = (HistoricJobLog)serviceTask1SuccessfulQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask1SuccessfulJobLogEntry.getJobRetries());
        HistoricJobLogTest.assertEquals((long)2L, (long)serviceTask2Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask2SuccessfulQuery.count());
        HistoricJobLog serviceTask2CreatedJobLogEntry = (HistoricJobLog)serviceTask2CreatedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask2CreatedJobLogEntry.getJobRetries());
        HistoricJobLog serviceTask2DeletedJobLogEntry = (HistoricJobLog)serviceTask2DeletedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask2DeletedJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testSuperProcessWithCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricJobLogTest.testSubProcessWithErrorEndEvent.bpmn20.xml"})
    public void testErrorEndEventInterruptingCallActivity() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery();
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        String serviceTask1JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask1").singleResult()).getId();
        HistoricJobLogQuery serviceTask1Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId);
        HistoricJobLogQuery serviceTask1CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).creationLog();
        HistoricJobLogQuery serviceTask1DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).deletionLog();
        HistoricJobLogQuery serviceTask1SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask1JobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask1DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask1SuccessfulQuery.count());
        String serviceTask2JobId = ((Job)this.managementService.createJobQuery().activityId("serviceTask2").singleResult()).getId();
        HistoricJobLogQuery serviceTask2Query = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId);
        HistoricJobLogQuery serviceTask2CreatedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).creationLog();
        HistoricJobLogQuery serviceTask2DeletedQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).deletionLog();
        HistoricJobLogQuery serviceTask2SuccessfulQuery = this.historyService.createHistoricJobLogQuery().jobId(serviceTask2JobId).successLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask2DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask2SuccessfulQuery.count());
        this.managementService.executeJob(serviceTask1JobId);
        HistoricJobLogTest.assertEquals((long)4L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)2L, (long)serviceTask1Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask1DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask1SuccessfulQuery.count());
        HistoricJobLog serviceTask1CreatedJobLogEntry = (HistoricJobLog)serviceTask1CreatedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask1CreatedJobLogEntry.getJobRetries());
        HistoricJobLog serviceTask1SuccessfulJobLogEntry = (HistoricJobLog)serviceTask1SuccessfulQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask1SuccessfulJobLogEntry.getJobRetries());
        HistoricJobLogTest.assertEquals((long)2L, (long)serviceTask2Query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2CreatedQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)serviceTask2DeletedQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)serviceTask2SuccessfulQuery.count());
        HistoricJobLog serviceTask2CreatedJobLogEntry = (HistoricJobLog)serviceTask2CreatedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask2CreatedJobLogEntry.getJobRetries());
        HistoricJobLog serviceTask2DeletedJobLogEntry = (HistoricJobLog)serviceTask2DeletedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)serviceTask2DeletedJobLogEntry.getJobRetries());
        HistoricJobLogTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testDeletedJob() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery deletedQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).deletionLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)deletedQuery.count());
        this.managementService.deleteJob(jobId);
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)deletedQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog deletedJobLogEntry = (HistoricJobLog)deletedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)deletedJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testDeletedProcessInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        HistoricJobLogQuery query = this.historyService.createHistoricJobLogQuery().jobId(jobId);
        HistoricJobLogQuery createdQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).creationLog();
        HistoricJobLogQuery deletedQuery = this.historyService.createHistoricJobLogQuery().jobId(jobId).deletionLog();
        HistoricJobLogTest.assertEquals((long)1L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)0L, (long)deletedQuery.count());
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        HistoricJobLogTest.assertEquals((long)2L, (long)query.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)createdQuery.count());
        HistoricJobLogTest.assertEquals((long)1L, (long)deletedQuery.count());
        HistoricJobLog createdJobLogEntry = (HistoricJobLog)createdQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)createdJobLogEntry.getJobRetries());
        HistoricJobLog deletedJobLogEntry = (HistoricJobLog)deletedQuery.singleResult();
        HistoricJobLogTest.assertEquals((int)3, (int)deletedJobLogEntry.getJobRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricJobLogTest.testAsyncContinuation.bpmn20.xml"})
    public void testExceptionStacktrace() {
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        String failedHistoricJobLogId = ((HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult()).getId();
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(failedHistoricJobLogId);
        HistoricJobLogTest.assertNotNull((Object)stacktrace);
        this.assertTextPresent("Expected exception.", stacktrace);
    }

    public void testgetJobExceptionStacktraceUnexistingJobId() {
        try {
            this.historyService.getHistoricJobLogExceptionStacktrace("unexistingjob");
            HistoricJobLogTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("No historic job log found with id unexistingjob", re.getMessage());
        }
    }

    public void testgetJobExceptionStacktraceNullJobId() {
        try {
            this.historyService.getHistoricJobLogExceptionStacktrace(null);
            HistoricJobLogTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.assertTextPresent("historicJobLogId is null", re.getMessage());
        }
    }

    @Deployment
    public void testDifferentExceptions() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLog serviceTask1FailedHistoricJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String serviceTask1FailedHistoricJobLogId = serviceTask1FailedHistoricJobLog.getId();
        HistoricJobLogTest.assertEquals((String)"First expected exception.", (String)serviceTask1FailedHistoricJobLog.getJobExceptionMessage());
        String serviceTask1Stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(serviceTask1FailedHistoricJobLogId);
        HistoricJobLogTest.assertNotNull((Object)serviceTask1Stacktrace);
        this.assertTextPresent("First expected exception.", serviceTask1Stacktrace);
        this.assertTextPresent(FirstFailingDelegate.class.getName(), serviceTask1Stacktrace);
        this.runtimeService.setVariable(processInstanceId, "firstFail", (Object)false);
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLog serviceTask2FailedHistoricJobLog = (HistoricJobLog)((HistoricJobLogQuery)this.historyService.createHistoricJobLogQuery().failureLog().orderByJobRetries().desc()).list().get(1);
        String serviceTask2FailedHistoricJobLogId = serviceTask2FailedHistoricJobLog.getId();
        HistoricJobLogTest.assertEquals((String)"Second expected exception.", (String)serviceTask2FailedHistoricJobLog.getJobExceptionMessage());
        String serviceTask2Stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(serviceTask2FailedHistoricJobLogId);
        HistoricJobLogTest.assertNotNull((Object)serviceTask2Stacktrace);
        this.assertTextPresent("Second expected exception.", serviceTask2Stacktrace);
        this.assertTextPresent(SecondFailingDelegate.class.getName(), serviceTask2Stacktrace);
        HistoricJobLogTest.assertFalse((boolean)serviceTask1Stacktrace.equals(serviceTask2Stacktrace));
    }

    @Deployment
    public void testThrowExceptionWithoutMessage() {
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
            HistoricJobLogTest.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        HistoricJobLog failedHistoricJobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String failedHistoricJobLogId = failedHistoricJobLog.getId();
        HistoricJobLogTest.assertNull((Object)failedHistoricJobLog.getJobExceptionMessage());
        String stacktrace = this.historyService.getHistoricJobLogExceptionStacktrace(failedHistoricJobLogId);
        HistoricJobLogTest.assertNotNull((Object)stacktrace);
        this.assertTextPresent(ThrowExceptionWithoutMessageDelegate.class.getName(), stacktrace);
    }

    public void testDeleteByteArray() {
        String processDefinitionId = "myProcessDefition";
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (int i = 0; i < 1234; ++i) {
                    HistoricJobLogEventEntity log = new HistoricJobLogEventEntity();
                    log.setJobId(String.valueOf(i));
                    log.setTimestamp(new Date());
                    log.setJobDefinitionType("message");
                    log.setProcessDefinitionId("myProcessDefition");
                    byte[] aByteValue = StringUtil.toByteArray((String)"abc");
                    ByteArrayEntity byteArray = JobExceptionUtil.createJobExceptionByteArray((byte[])aByteValue);
                    log.setExceptionByteArrayId(byteArray.getId());
                    commandContext.getHistoricJobLogManager().insert((DbEntity)log);
                }
                return null;
            }
        });
        HistoricJobLogTest.assertEquals((long)1234L, (long)this.historyService.createHistoricJobLogQuery().count());
        this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByProcessDefinitionId("myProcessDefition");
                return null;
            }
        });
        HistoricJobLogTest.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().count());
    }
}

