/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class HistoricVariableInstanceScopeTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariableOnProcessInstanceStart() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "testValue");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)variable);
        HistoricVariableInstanceScopeTest.assertEquals((String)pi.getId(), (String)variable.getActivityInstanceId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariableLocalOnUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "testVar", (Object)"testValue");
        ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)taskExecution);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)variable);
        HistoricVariableInstanceScopeTest.assertEquals((String)taskExecution.getActivityInstanceId(), (String)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetVariableOnProcessIntanceStartAndSetVariableLocalOnUserTask() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "testValue");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "testVar", (Object)"anotherTestValue");
        ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)taskExecution);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)2L, (long)query.count());
        List result = query.list();
        HistoricVariableInstance firstVar = (HistoricVariableInstance)result.get(0);
        HistoricVariableInstanceScopeTest.assertEquals((String)"testVar", (String)firstVar.getVariableName());
        HistoricVariableInstanceScopeTest.assertEquals((Object)"testValue", (Object)firstVar.getValue());
        HistoricVariableInstanceScopeTest.assertEquals((String)pi.getId(), (String)firstVar.getActivityInstanceId());
        HistoricVariableInstance secondVar = (HistoricVariableInstance)result.get(1);
        HistoricVariableInstanceScopeTest.assertEquals((String)"testVar", (String)secondVar.getVariableName());
        HistoricVariableInstanceScopeTest.assertEquals((Object)"anotherTestValue", (Object)secondVar.getValue());
        HistoricVariableInstanceScopeTest.assertEquals((String)taskExecution.getActivityInstanceId(), (String)secondVar.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    public void testSetVariableOnUserTaskInsideSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "testVar", (Object)"testValue");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)pi.getId(), (String)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testSetVariableOnServiceTaskInsideSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)pi.getId(), (String)variable.getActivityInstanceId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testSetVariableLocalOnServiceTaskInsideSubProcess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("SubProcess_1").singleResult()).getId();
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)activityInstanceId, (String)variable.getActivityInstanceId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testSetVariableLocalOnTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "testVar", (Object)"testValue");
        ExecutionEntity taskExecution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)taskExecution);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)taskExecution.getActivityInstanceId(), (String)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceScopeTest.testSetVariableLocalOnTaskInsideParallelBranch.bpmn"})
    public void testSetVariableOnTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)task);
        this.taskService.setVariable(task.getId(), "testVar", (Object)"testValue");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)pi.getId(), (String)variable.getActivityInstanceId());
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testSetVariableOnServiceTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)pi.getId(), (String)variable.getActivityInstanceId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testSetVariableLocalOnServiceTaskInsideParallelBranch() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        HistoricActivityInstance serviceTask = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("serviceTask1").singleResult();
        HistoricVariableInstanceScopeTest.assertNotNull((Object)serviceTask);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)query.count());
        HistoricVariableInstance variable = (HistoricVariableInstance)query.singleResult();
        HistoricVariableInstanceScopeTest.assertEquals((String)serviceTask.getId(), (String)variable.getActivityInstanceId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testHistoricCaseVariableInstanceQuery() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase", variables).getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("CasePlanModel_1").singleResult()).getId();
        String taskExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.setVariableLocal(caseExecutionId, "case", (Object)"execution");
        this.caseService.setVariableLocal(taskExecutionId, "task", (Object)"execution");
        this.caseService.setVariableLocal(caseExecutionId, "case", (Object)"update");
        this.caseService.setVariableLocal(taskExecutionId, "task", (Object)"update");
        HistoricVariableInstanceScopeTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceScopeTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().caseInstanceId(caseInstanceId).count());
        HistoricVariableInstanceScopeTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId, taskExecutionId}).count());
        HistoricVariableInstanceScopeTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().caseExecutionIdIn(new String[]{caseExecutionId}).count());
        HistoricVariableInstanceScopeTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().caseExecutionIdIn(new String[]{taskExecutionId}).count());
        HistoryLevel historyLevel = this.processEngineConfiguration.getHistoryLevel();
        if (historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            HistoricVariableInstanceScopeTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
            HistoricVariableInstanceScopeTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().caseInstanceId(caseInstanceId).count());
            HistoricVariableInstanceScopeTest.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().caseExecutionId(caseExecutionId).count());
            HistoricVariableInstanceScopeTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().caseExecutionId(taskExecutionId).count());
        }
    }
}

