/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.camunda.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.camunda.bpm.engine.test.history.UpdateValueDelegate;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;

public class HistoricVariableInstanceTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/examples/bpmn/callactivity/orderProcess.bpmn20.xml", "org/camunda/bpm/engine/test/examples/bpmn/callactivity/checkCreditProcess.bpmn20.xml"})
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"Verify credit history", (String)verifyCreditTask.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)subProcessInstance);
        HistoricVariableInstanceTest.assertEquals((String)pi.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"Prepare and Ship", (String)prepareAndShipTask.getName());
    }

    @Deployment
    public void testSimple() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testSimpleNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testParallel() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.complete(userTask.getId(), CollectionUtil.singletonMap((String)"myVar", (Object)"test789"));
        this.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"myVar", (String)historicVariable.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test789", (String)historicVariable.getTextValue());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        HistoricVariableInstanceTest.assertEquals((String)"myVar1", (String)historicVariable1.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable1.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testParallelNoWaitState() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        this.assertProcessEnded(processInstance.getId());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"test456", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((long)7L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment
    public void testTwoSubProcessInParallelWithinSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoSubProcessInParallelWithinSubProcess");
        this.assertProcessEnded(processInstance.getId());
        List variables = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variables.size());
        HistoricVariableInstanceEntity historicVariable = (HistoricVariableInstanceEntity)variables.get(0);
        HistoricVariableInstanceTest.assertEquals((String)"myVar", (String)historicVariable.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test101112", (String)historicVariable.getTextValue());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable.getVariableTypeName());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable.getTypeName());
        HistoricVariableInstanceEntity historicVariable1 = (HistoricVariableInstanceEntity)variables.get(1);
        HistoricVariableInstanceTest.assertEquals((String)"myVar1", (String)historicVariable1.getName());
        HistoricVariableInstanceTest.assertEquals((String)"test789", (String)historicVariable1.getTextValue());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable1.getVariableTypeName());
        HistoricVariableInstanceTest.assertEquals((String)"string", (String)historicVariable1.getTypeName());
        HistoricVariableInstanceTest.assertEquals((long)18L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/history/simpleSubProcess.bpmn20.xml"})
    public void testHistoricVariableInstanceQuery() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)this.historyService.createHistoricVariableInstanceQuery().list().size());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByProcessInstanceId().asc()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).count());
        HistoricVariableInstanceTest.assertEquals((int)4, (int)((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().variableName("myVar").list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").count());
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().variableNameLike("myVar1").list().size());
        List variables = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceTest.assertEquals((int)4, (int)variables.size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test123").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test456").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar", (Object)"test666").list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("myVar1", (Object)"test666").list().size());
        HistoricVariableInstanceTest.assertEquals((long)8L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        if (this.isFullHistoryEnabled()) {
            HistoricVariableInstanceTest.assertEquals((long)5L, (long)this.historyService.createHistoricDetailQuery().count());
        }
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId("non-existing").count());
        List variable = this.historyService.createHistoricVariableInstanceQuery().listPage(0, 1);
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableId(((HistoricVariableInstance)variable.get(0)).getId()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testCallSubProcessSettingVariableOnStart.bpmn20.xml", "org/camunda/bpm/engine/test/history/subProcessSetVariableOnStart.bpmn20.xml"})
    public void testCallSubProcessSettingVariableOnStart() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSubProcess");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("aVariable", (Object)"aValue").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricProcessVariableOnDeletion() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("testVar", "Hallo Christian");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "deleted");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).variableValueEquals("testVar", (Object)"Hallo Christian").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdatesAreLinkedToActivity.bpmn20.xml"})
    public void testVariableUpdatesLinkedToActivity() throws Exception {
        if (this.isFullHistoryEnabled()) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("ProcessWithSubProcess");
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("test", "1");
            this.taskService.complete(task.getId(), variables);
            task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            variables.clear();
            variables.put("test", "2");
            this.taskService.complete(task.getId(), variables);
            this.assertProcessEnded(pi.getId());
            List updates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
            HistoricVariableInstanceTest.assertEquals((int)2, (int)updates.size());
            HashMap<String, HistoricVariableUpdate> updatesMap = new HashMap<String, HistoricVariableUpdate>();
            HistoricVariableUpdate update = (HistoricVariableUpdate)updates.get(0);
            updatesMap.put((String)update.getValue(), update);
            update = (HistoricVariableUpdate)updates.get(1);
            updatesMap.put((String)update.getValue(), update);
            HistoricVariableUpdate update1 = (HistoricVariableUpdate)updatesMap.get("1");
            HistoricVariableUpdate update2 = (HistoricVariableUpdate)updatesMap.get("2");
            HistoricVariableInstanceTest.assertNotNull((Object)update1.getActivityInstanceId());
            HistoricVariableInstanceTest.assertNotNull((Object)update1.getExecutionId());
            HistoricActivityInstance historicActivityInstance1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update1.getActivityInstanceId()).singleResult();
            HistoricVariableInstanceTest.assertEquals((String)historicActivityInstance1.getExecutionId(), (String)update1.getExecutionId());
            HistoricVariableInstanceTest.assertEquals((String)"usertask1", (String)historicActivityInstance1.getActivityId());
            HistoricVariableInstanceTest.assertNotNull((Object)update2.getActivityInstanceId());
            HistoricActivityInstance historicActivityInstance2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update2.getActivityInstanceId()).singleResult();
            HistoricVariableInstanceTest.assertEquals((String)"usertask2", (String)historicActivityInstance2.getActivityId());
            HistoricVariableInstanceTest.assertFalse((boolean)historicActivityInstance2.getExecutionId().equals(update2.getExecutionId()));
        }
    }

    @Deployment
    public void testHistoricProcessInstanceDeleteCascadesCorrectly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("var1", "value1");
        variables.put("var2", "value2");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        HistoricVariableInstanceTest.assertNotNull((Object)processInstance);
        variables = new HashMap();
        variables.put("var3", "value3");
        variables.put("var4", "value4");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("myProcess", variables);
        HistoricVariableInstanceTest.assertNotNull((Object)processInstance2);
        long count = this.historyService.createHistoricVariableInstanceQuery().count();
        HistoricVariableInstanceTest.assertEquals((long)4L, (long)count);
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "reason 1");
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        count = this.historyService.createHistoricVariableInstanceQuery().count();
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)count);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testParallel.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByTaskIds() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("myProc");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task userTask = (Task)taskQuery.singleResult();
        HistoricVariableInstanceTest.assertEquals((String)"userTask1", (String)userTask.getName());
        this.taskService.setVariableLocal(userTask.getId(), "taskVariable", (Object)"aCustomValue");
        this.taskService.complete(userTask.getId());
        this.assertProcessEnded(processInstance.getId());
        List tasks = this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getProcessInstanceId()).list();
        HistoricVariableInstanceTest.assertEquals((int)1, (int)tasks.size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceTest.assertEquals((int)1, (int)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{((HistoricTaskInstance)tasks.get(0)).getId()}).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableInstanceQueryByExecutionIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceTest.assertEquals((int)2, (int)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId()}).count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        HistoricVariableInstanceTest.assertEquals((int)3, (int)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()}).list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{processInstance1.getId(), processInstance2.getId()}).count());
    }

    public void testQueryByInvalidExecutionIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().executionIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByInvalidTaskIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByActivityInstanceIdIn() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        variables1.put("myVar", "test123");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables1);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.activityInstanceIdIn(new String[]{processInstance1.getId()});
        HistoricVariableInstanceTest.assertEquals((int)2, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)2L, (long)query.count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("myVar", "test123");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables2);
        query.activityInstanceIdIn(new String[]{processInstance1.getId(), processInstance2.getId()});
        HistoricVariableInstanceTest.assertEquals((int)3, (int)query.list().size());
        HistoricVariableInstanceTest.assertEquals((long)3L, (long)query.count());
    }

    public void testQueryByInvalidActivityInstanceIdIn() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        query.taskIdIn(new String[]{"invalid"});
        HistoricVariableInstanceTest.assertEquals((long)0L, (long)query.count());
        try {
            query.taskIdIn(null);
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.taskIdIn(new String[]{null});
            HistoricVariableInstanceTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testBinaryFetchingEnabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testBinaryFetchingDisabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).disableBinaryFetching().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variableInstance.getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testDisableCustomObjectDeserialization() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List variableInstances = this.historyService.createHistoricVariableInstanceQuery().disableCustomObjectDeserialization().list();
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variableInstances.size());
        for (HistoricVariableInstance variableInstance : variableInstances) {
            HistoricVariableInstanceTest.assertNull((Object)variableInstance.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableInstance.getTypedValue();
            HistoricVariableInstanceTest.assertNotNull((Object)typedValue);
            HistoricVariableInstanceTest.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            HistoricVariableInstanceTest.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testErrorMessage() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "failingSerializable";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)new FailingSerializable());
        HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName(variableName).singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variableInstance.getValue());
        HistoricVariableInstanceTest.assertNotNull((Object)variableInstance.getErrorMessage());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Deployment
    public void testHistoricVariableInstanceRevision() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)variable;
        HistoricVariableInstanceTest.assertEquals((int)0, (int)variableEntity.getRevision());
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableRevision().asc()).list();
            for (HistoricDetail detail : details) {
                HistoricVariableUpdate variableDetail = (HistoricVariableUpdate)detail;
                HistoricVariableInstanceTest.assertEquals((int)0, (int)variableDetail.getRevision());
            }
        }
    }

    @Deployment
    public void testHistoricVariableInstanceRevisionAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)variable;
        HistoricVariableInstanceTest.assertEquals((int)2, (int)variableEntity.getRevision());
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableRevision().asc()).list();
            int i = 0;
            for (HistoricDetail detail : details) {
                HistoricVariableUpdate variableDetail = (HistoricVariableUpdate)detail;
                HistoricVariableInstanceTest.assertEquals((int)i, (int)variableDetail.getRevision());
                ++i;
            }
        }
    }

    @Deployment
    public void FAILING_testImplicitVariableObjectValueUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        HistoricVariableInstanceTest.assertNotNull((Object)list);
        HistoricVariableInstanceTest.assertEquals((int)1, (int)list.size());
        HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)list.get(0)));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("listVar").singleResult();
        List historicList = (List)historicVariableInstance.getValue();
        HistoricVariableInstanceTest.assertNotNull((Object)historicList);
        HistoricVariableInstanceTest.assertEquals((int)1, (int)historicList.size());
        HistoricVariableInstanceTest.assertEquals((String)"new element", (String)((String)historicList.get(0)));
    }

    protected boolean isFullHistoryEnabled() {
        return this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testHistoricVariableInstanceRevision.bpmn20.xml"})
    public void testVariableUpdateOrder() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variable.getId()).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testHistoricVariableInstanceRevisionAsync.bpmn20.xml"})
    public void testVariableUpdateOrderAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.executeAvailableJobs();
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variable.getId()).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskVariableUpdateOrder() {
        HistoricVariableUpdate fourthUpdate;
        HistoricVariableUpdate thirdUpdate;
        HistoricVariableUpdate secondUpdate;
        HistoricVariableUpdate firstUpdate;
        List details;
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)1);
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)2);
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)3);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.taskService.setVariableLocal(taskId, "myVariable", (Object)"abc");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)4, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.taskService.removeVariable(taskId, "myVariable");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)5, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate fifthUpdate = (HistoricVariableUpdate)details.get(4);
            HistoricVariableInstanceTest.assertNull((Object)fifthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fifthUpdate).getSequenceCounter() > ((HistoryEvent)fourthUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCaseVariableUpdateOrder() {
        HistoricVariableUpdate fourthUpdate;
        HistoricVariableUpdate thirdUpdate;
        HistoricVariableUpdate secondUpdate;
        HistoricVariableUpdate firstUpdate;
        List details;
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)2);
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)3);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)"abc");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)4, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
        this.caseService.removeVariable(caseInstanceId, "myVariable");
        variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNull((Object)variable);
        if (this.isFullHistoryEnabled()) {
            details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)5, (int)details.size());
            firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)3, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
            fourthUpdate = (HistoricVariableUpdate)details.get(3);
            HistoricVariableInstanceTest.assertEquals((Object)"abc", (Object)fourthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fourthUpdate).getSequenceCounter() > ((HistoryEvent)thirdUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate fifthUpdate = (HistoricVariableUpdate)details.get(4);
            HistoricVariableInstanceTest.assertNull((Object)fifthUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)fifthUpdate).getSequenceCounter() > ((HistoryEvent)fourthUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSetSameVariableUpdateOrder() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariable(taskId, "myVariable", (Object)1);
        this.taskService.setVariable(taskId, "myVariable", (Object)1);
        this.taskService.setVariable(taskId, "myVariable", (Object)2);
        HistoricVariableInstance variable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        HistoricVariableInstanceTest.assertNotNull((Object)variable);
        String variableInstanceId = variable.getId();
        if (this.isFullHistoryEnabled()) {
            List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableInstanceId(variableInstanceId).orderPartiallyByOccurrence().asc()).list();
            HistoricVariableInstanceTest.assertEquals((int)3, (int)details.size());
            HistoricVariableUpdate firstUpdate = (HistoricVariableUpdate)details.get(0);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)firstUpdate.getValue());
            HistoricVariableUpdate secondUpdate = (HistoricVariableUpdate)details.get(1);
            HistoricVariableInstanceTest.assertEquals((Object)1, (Object)secondUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)secondUpdate).getSequenceCounter() > ((HistoryEvent)firstUpdate).getSequenceCounter() ? 1 : 0) != 0);
            HistoricVariableUpdate thirdUpdate = (HistoricVariableUpdate)details.get(2);
            HistoricVariableInstanceTest.assertEquals((Object)2, (Object)thirdUpdate.getValue());
            HistoricVariableInstanceTest.assertTrue((((HistoryEvent)thirdUpdate).getSequenceCounter() > ((HistoryEvent)secondUpdate).getSequenceCounter() ? 1 : 0) != 0);
        }
    }
}

