/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.persistence;

import java.util.List;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.persistence.ExecutionOrderListener;
import org.junit.Before;

public class ExecutionSequenceCounterTest
extends PluggableProcessEngineTestCase {
    @Before
    public void setUp() {
        ExecutionOrderListener.clearActivityExecutionOrder();
    }

    @Deployment
    public void testSequence() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theService2", "theEnd");
    }

    @Deployment
    public void testForkSameSequenceLengthWithoutWaitStates() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService", "fork", "theService1", "theEnd1", "theService2", "theEnd2");
    }

    @Deployment
    public void testForkSameSequenceLengthWithAsyncEndEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)5, (int)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theStart", (String)theStartElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService", (String)theForkElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"fork", (String)theServiceElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theEnd1").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)6, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd1", (String)theEnd1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd1Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theEnd2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)7, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd2", (String)theEnd2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd2Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    public void testForkDifferentSequenceLengthWithoutWaitStates() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService", "fork", "theService1", "theEnd1", "theService2", "theService3", "theEnd2");
    }

    @Deployment
    public void testForkDifferentSequenceLengthWithAsyncEndEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)6, (int)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theStart", (String)theStartElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService", (String)theForkElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"fork", (String)theServiceElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theEnd1").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)7, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd1", (String)theEnd1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd1Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theEnd2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)8, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(7);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd2", (String)theEnd2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd2Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    public void testForkReplaceBy() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)2, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() == theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theService4").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)5, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theService4", (String)theService4Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService4Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService5Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService5", (String)theService5Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService5Element.getSequenceCounter() > theService4Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd2", (String)theEnd2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd2Element.getSequenceCounter() > theService5Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)7, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > theEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd1", (String)theEnd1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd1Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/persistence/ExecutionSequenceCounterTest.testForkReplaceBy.bpmn20.xml"})
    public void testForkReplaceByAnotherExecutionOrder() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)2, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() == theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theService2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)4, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd1", (String)theEnd1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd1Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService4").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)7, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theService4", (String)theService4Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService4Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService4Element.getSequenceCounter() > theEnd1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService5Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theService5", (String)theService5Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService5Element.getSequenceCounter() > theService4Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd2", (String)theEnd2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd2Element.getSequenceCounter() > theService5Element.getSequenceCounter() ? 1 : 0) != 0);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testForkReplaceByThreeBranches() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery jobQuery = this.managementService.createJobQuery();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)3, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService6Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theService6", (String)theService6Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() == theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() == theService6Element.getSequenceCounter() ? 1 : 0) != 0);
        String jobId = ((Job)jobQuery.activityId("theService2").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)5, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd1", (String)theEnd1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd1Element.getSequenceCounter() > theService2Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService4").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)8, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theService4", (String)theService4Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService4Element.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService5Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theService5", (String)theService5Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService5Element.getSequenceCounter() > theService4Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(7);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd2", (String)theEnd2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd2Element.getSequenceCounter() > theService5Element.getSequenceCounter() ? 1 : 0) != 0);
        jobId = ((Job)jobQuery.activityId("theService7").singleResult()).getId();
        this.managementService.executeJob(jobId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)12, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService7Element = order.get(8);
        ExecutionSequenceCounterTest.assertEquals((String)"theService7", (String)theService7Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService7Element.getSequenceCounter() > theService6Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService7Element.getSequenceCounter() > theEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService8Element = order.get(9);
        ExecutionSequenceCounterTest.assertEquals((String)"theService8", (String)theService8Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService8Element.getSequenceCounter() > theService7Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService9Element = order.get(10);
        ExecutionSequenceCounterTest.assertEquals((String)"theService9", (String)theService9Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService9Element.getSequenceCounter() > theService8Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd3Element = order.get(11);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd3", (String)theEnd3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd3Element.getSequenceCounter() > theService9Element.getSequenceCounter() ? 1 : 0) != 0);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testForkAndJoinSameSequenceLength() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)9, (int)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theStart", (String)theStartElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService", (String)theForkElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"fork", (String)theServiceElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService1Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin1Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theJoin1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService2Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin2Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theJoin2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(7);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() > theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() > theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        lastSequenceCounter = theService3Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theEndElement = order.get(8);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd", (String)theEndElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEndElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
    }

    @Deployment
    public void testForkAndJoinDifferentSequenceLength() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)10, (int)order.size());
        long lastSequenceCounter = 0L;
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theStart", (String)theStartElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theStartElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theStartElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theForkElement = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService", (String)theForkElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theForkElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceElement = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"fork", (String)theServiceElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theServiceElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theServiceElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService1Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin1Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theJoin1Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theForkElement.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService2Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService2Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        lastSequenceCounter = theService3Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin2Element = order.get(7);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theJoin2Element.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertFalse((theJoin1Element.getSequenceCounter() == theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService4Element = order.get(8);
        ExecutionSequenceCounterTest.assertEquals((String)"theService4", (String)theService4Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService4Element.getSequenceCounter() > theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService4Element.getSequenceCounter() > theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        lastSequenceCounter = theService4Element.getSequenceCounter();
        ExecutionOrderListener.ActivitySequenceCounterMap theEndElement = order.get(9);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd", (String)theEndElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEndElement.getSequenceCounter() > lastSequenceCounter ? 1 : 0) != 0);
    }

    @Deployment
    public void testForkAndJoinThreeBranchesDifferentSequenceLength() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)4, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin1Element = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin2Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin2Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theJoin3Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"join", (String)theJoin3Element.getActivityId());
        ExecutionSequenceCounterTest.assertFalse((theJoin1Element.getSequenceCounter() == theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertFalse((theJoin2Element.getSequenceCounter() == theJoin3Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertFalse((theJoin3Element.getSequenceCounter() == theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService7Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService7", (String)theService7Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService7Element.getSequenceCounter() > theJoin1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService7Element.getSequenceCounter() > theJoin2Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService7Element.getSequenceCounter() > theJoin3Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    public void testSequenceInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "subProcess", "innerStart", "innerService", "innerEnd", "theService2", "theEnd");
    }

    @Deployment
    public void testForkSameSequenceLengthInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)3, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd1Element = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"innerEnd1", (String)innerEnd1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd2Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"innerEnd2", (String)innerEnd2Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > innerEnd1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > innerEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    public void testForkDifferentSequenceLengthInsideSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)3, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd1Element = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"innerEnd1", (String)innerEnd1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap innerEnd2Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"innerEnd2", (String)innerEnd2Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > innerEnd1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > innerEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    public void testSequentialMultiInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theService2", "theService2", "theService3", "theEnd");
    }

    @Deployment
    public void testParallelMultiInstance() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)6, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theStartElement = order.get(0);
        ExecutionSequenceCounterTest.assertEquals((String)"theStart", (String)theStartElement.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService1Element.getSequenceCounter() > theStartElement.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService21Element = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService21Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService21Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService22Element = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"theService2", (String)theService22Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService22Element.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theService3Element = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theService3", (String)theService3Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() > theService21Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertTrue((theService3Element.getSequenceCounter() > theService22Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEndElement = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd", (String)theEndElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEndElement.getSequenceCounter() > theService3Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    @Deployment
    public void testLoop() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.assertProcessEnded(processInstanceId);
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "join", "theScript", "fork", "join", "theScript", "fork", "theService2", "theEnd");
    }

    @Deployment
    public void testInterruptingBoundaryEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theTask");
        this.runtimeService.correlateMessage("newMessage");
        this.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theTask", "messageBoundary", "theServiceAfterMessage", "theEnd2");
    }

    @Deployment
    public void testNonInterruptingBoundaryEvent() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        List<ExecutionOrderListener.ActivitySequenceCounterMap> order = ExecutionOrderListener.getActivityExecutionOrder();
        this.verifyOrder(order, "theStart", "theService1", "theTask");
        this.runtimeService.correlateMessage("newMessage");
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)6, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theService1Element = order.get(1);
        ExecutionSequenceCounterTest.assertEquals((String)"theService1", (String)theService1Element.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap theTaskElement = order.get(2);
        ExecutionSequenceCounterTest.assertEquals((String)"theTask", (String)theTaskElement.getActivityId());
        ExecutionOrderListener.ActivitySequenceCounterMap messageBoundaryElement = order.get(3);
        ExecutionSequenceCounterTest.assertEquals((String)"messageBoundary", (String)messageBoundaryElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((messageBoundaryElement.getSequenceCounter() > theService1Element.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionSequenceCounterTest.assertFalse((messageBoundaryElement.getSequenceCounter() > theTaskElement.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theServiceAfterMessageElement = order.get(4);
        ExecutionSequenceCounterTest.assertEquals((String)"theServiceAfterMessage", (String)theServiceAfterMessageElement.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theServiceAfterMessageElement.getSequenceCounter() > messageBoundaryElement.getSequenceCounter() ? 1 : 0) != 0);
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd2Element = order.get(5);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd2", (String)theEnd2Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd2Element.getSequenceCounter() > theServiceAfterMessageElement.getSequenceCounter() ? 1 : 0) != 0);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
        order = ExecutionOrderListener.getActivityExecutionOrder();
        ExecutionSequenceCounterTest.assertEquals((int)7, (int)order.size());
        ExecutionOrderListener.ActivitySequenceCounterMap theEnd1Element = order.get(6);
        ExecutionSequenceCounterTest.assertEquals((String)"theEnd1", (String)theEnd1Element.getActivityId());
        ExecutionSequenceCounterTest.assertTrue((theEnd1Element.getSequenceCounter() > theEnd2Element.getSequenceCounter() ? 1 : 0) != 0);
    }

    protected void verifyOrder(List<ExecutionOrderListener.ActivitySequenceCounterMap> actualOrder, String ... expectedOrder) {
        ExecutionSequenceCounterTest.assertEquals((int)expectedOrder.length, (int)actualOrder.size());
        long lastActualSequenceCounter = 0L;
        for (int i = 0; i < expectedOrder.length; ++i) {
            ExecutionOrderListener.ActivitySequenceCounterMap actual = actualOrder.get(i);
            String actualActivityId = actual.getActivityId();
            String expectedActivityId = expectedOrder[i];
            ExecutionSequenceCounterTest.assertEquals((String)actualActivityId, (String)expectedActivityId);
            long actualSequenceCounter = actual.getSequenceCounter();
            ExecutionSequenceCounterTest.assertTrue((actualSequenceCounter > lastActualSequenceCounter ? 1 : 0) != 0);
            lastActualSequenceCounter = actualSequenceCounter;
        }
    }
}

