/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.task.TaskDecorator;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;

public class TaskDecoratorTest
extends PluggableProcessEngineTestCase {
    protected TaskEntity task;
    protected TaskDefinition taskDefinition;
    protected TaskDecorator taskDecorator;
    protected ExpressionManager expressionManager;

    public void setUp() {
        this.task = (TaskEntity)this.taskService.newTask();
        this.taskService.saveTask((Task)this.task);
        this.expressionManager = this.processEngineConfiguration.getExpressionManager();
        this.taskDefinition = new TaskDefinition(null);
        this.taskDecorator = new TaskDecorator(this.taskDefinition, this.expressionManager);
    }

    public void tearDown() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new DeleteTaskCommand(this.task));
    }

    protected void decorate(TaskEntity task, TaskDecorator decorator) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new DecorateTaskCommand(task, decorator));
    }

    public void testDecorateName() {
        String aTaskName = "A Task Name";
        Expression nameExpression = this.expressionManager.createExpression(aTaskName);
        this.taskDefinition.setNameExpression(nameExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((String)aTaskName, (String)this.task.getName());
    }

    public void testDecorateNameFromVariable() {
        String aTaskName = "A Task Name";
        this.taskService.setVariable(this.task.getId(), "taskName", (Object)aTaskName);
        Expression nameExpression = this.expressionManager.createExpression("${taskName}");
        this.taskDefinition.setNameExpression(nameExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((String)aTaskName, (String)this.task.getName());
    }

    public void testDecorateDescription() {
        String aDescription = "This is a Task";
        Expression descriptionExpression = this.expressionManager.createExpression(aDescription);
        this.taskDefinition.setDescriptionExpression(descriptionExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((String)aDescription, (String)this.task.getDescription());
    }

    public void testDecorateDescriptionFromVariable() {
        String aDescription = "This is a Task";
        this.taskService.setVariable(this.task.getId(), "description", (Object)aDescription);
        Expression descriptionExpression = this.expressionManager.createExpression("${description}");
        this.taskDefinition.setDescriptionExpression(descriptionExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((String)aDescription, (String)this.task.getDescription());
    }

    public void testDecorateDueDate() {
        String aDueDate = "2014-06-01";
        Date dueDate = DateTimeUtil.parseDate((String)aDueDate);
        Expression dueDateExpression = this.expressionManager.createExpression(aDueDate);
        this.taskDefinition.setDueDateExpression(dueDateExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((Object)dueDate, (Object)this.task.getDueDate());
    }

    public void testDecorateDueDateFromVariable() {
        String aDueDate = "2014-06-01";
        Date dueDate = DateTimeUtil.parseDate((String)aDueDate);
        this.taskService.setVariable(this.task.getId(), "dueDate", (Object)dueDate);
        Expression dueDateExpression = this.expressionManager.createExpression("${dueDate}");
        this.taskDefinition.setDueDateExpression(dueDateExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((Object)dueDate, (Object)this.task.getDueDate());
    }

    public void testDecorateFollowUpDate() {
        String aFollowUpDate = "2014-06-01";
        Date followUpDate = DateTimeUtil.parseDate((String)aFollowUpDate);
        Expression followUpDateExpression = this.expressionManager.createExpression(aFollowUpDate);
        this.taskDefinition.setFollowUpDateExpression(followUpDateExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((Object)followUpDate, (Object)this.task.getFollowUpDate());
    }

    public void testDecorateFollowUpDateFromVariable() {
        String aFollowUpDateDate = "2014-06-01";
        Date followUpDate = DateTimeUtil.parseDate((String)aFollowUpDateDate);
        this.taskService.setVariable(this.task.getId(), "followUpDate", (Object)followUpDate);
        Expression followUpDateExpression = this.expressionManager.createExpression("${followUpDate}");
        this.taskDefinition.setFollowUpDateExpression(followUpDateExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((Object)followUpDate, (Object)this.task.getFollowUpDate());
    }

    public void testDecoratePriority() {
        String aPriority = "10";
        Expression priorityExpression = this.expressionManager.createExpression(aPriority);
        this.taskDefinition.setPriorityExpression(priorityExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((int)Integer.parseInt(aPriority), (int)this.task.getPriority());
    }

    public void testDecoratePriorityFromVariable() {
        int aPriority = 10;
        this.taskService.setVariable(this.task.getId(), "priority", (Object)aPriority);
        Expression priorityExpression = this.expressionManager.createExpression("${priority}");
        this.taskDefinition.setPriorityExpression(priorityExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((int)aPriority, (int)this.task.getPriority());
    }

    public void testDecorateAssignee() {
        String aAssignee = "john";
        Expression assigneeExpression = this.expressionManager.createExpression(aAssignee);
        this.taskDefinition.setAssigneeExpression(assigneeExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((String)aAssignee, (String)this.task.getAssignee());
    }

    public void testDecorateAssigneeFromVariable() {
        String aAssignee = "john";
        this.taskService.setVariable(this.task.getId(), "assignee", (Object)aAssignee);
        Expression assigneeExpression = this.expressionManager.createExpression("${assignee}");
        this.taskDefinition.setAssigneeExpression(assigneeExpression);
        this.decorate(this.task, this.taskDecorator);
        TaskDecoratorTest.assertEquals((String)aAssignee, (String)this.task.getAssignee());
    }

    public void testDecorateCandidateUsers() {
        ArrayList<String> aCandidateUserList = new ArrayList<String>();
        aCandidateUserList.add("john");
        aCandidateUserList.add("peter");
        aCandidateUserList.add("mary");
        for (String candidateUser : aCandidateUserList) {
            Expression candidateUserExpression = this.expressionManager.createExpression(candidateUser);
            this.taskDefinition.addCandidateUserIdExpression(candidateUserExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        TaskDecoratorTest.assertEquals((int)3, (int)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            TaskDecoratorTest.assertEquals((String)this.task.getId(), (String)taskId);
            TaskDecoratorTest.assertEquals((String)"candidate", (String)identityLink.getType());
            String userId = identityLink.getUserId();
            if ("john".equals(userId)) {
                TaskDecoratorTest.assertEquals((String)"john", (String)userId);
                continue;
            }
            if ("peter".equals(userId)) {
                TaskDecoratorTest.assertEquals((String)"peter", (String)userId);
                continue;
            }
            if ("mary".equals(userId)) {
                TaskDecoratorTest.assertEquals((String)"mary", (String)userId);
                continue;
            }
            TaskDecoratorTest.fail((String)("Unexpected user: " + userId));
        }
    }

    public void testDecorateCandidateUsersFromVariable() {
        this.taskService.setVariable(this.task.getId(), "john", (Object)"john");
        this.taskService.setVariable(this.task.getId(), "peter", (Object)"peter");
        this.taskService.setVariable(this.task.getId(), "mary", (Object)"mary");
        ArrayList<String> aCandidateUserList = new ArrayList<String>();
        aCandidateUserList.add("${john}");
        aCandidateUserList.add("${peter}");
        aCandidateUserList.add("${mary}");
        for (String candidateUser : aCandidateUserList) {
            Expression candidateUserExpression = this.expressionManager.createExpression(candidateUser);
            this.taskDefinition.addCandidateUserIdExpression(candidateUserExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        TaskDecoratorTest.assertEquals((int)3, (int)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            TaskDecoratorTest.assertEquals((String)this.task.getId(), (String)taskId);
            TaskDecoratorTest.assertEquals((String)"candidate", (String)identityLink.getType());
            String userId = identityLink.getUserId();
            if ("john".equals(userId)) {
                TaskDecoratorTest.assertEquals((String)"john", (String)userId);
                continue;
            }
            if ("peter".equals(userId)) {
                TaskDecoratorTest.assertEquals((String)"peter", (String)userId);
                continue;
            }
            if ("mary".equals(userId)) {
                TaskDecoratorTest.assertEquals((String)"mary", (String)userId);
                continue;
            }
            TaskDecoratorTest.fail((String)("Unexpected user: " + userId));
        }
    }

    public void testDecorateCandidateGroups() {
        ArrayList<String> aCandidateGroupList = new ArrayList<String>();
        aCandidateGroupList.add("management");
        aCandidateGroupList.add("accounting");
        aCandidateGroupList.add("backoffice");
        for (String candidateGroup : aCandidateGroupList) {
            Expression candidateGroupExpression = this.expressionManager.createExpression(candidateGroup);
            this.taskDefinition.addCandidateGroupIdExpression(candidateGroupExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        TaskDecoratorTest.assertEquals((int)3, (int)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            TaskDecoratorTest.assertEquals((String)this.task.getId(), (String)taskId);
            TaskDecoratorTest.assertEquals((String)"candidate", (String)identityLink.getType());
            String groupId = identityLink.getGroupId();
            if ("management".equals(groupId)) {
                TaskDecoratorTest.assertEquals((String)"management", (String)groupId);
                continue;
            }
            if ("accounting".equals(groupId)) {
                TaskDecoratorTest.assertEquals((String)"accounting", (String)groupId);
                continue;
            }
            if ("backoffice".equals(groupId)) {
                TaskDecoratorTest.assertEquals((String)"backoffice", (String)groupId);
                continue;
            }
            TaskDecoratorTest.fail((String)("Unexpected group: " + groupId));
        }
    }

    public void testDecorateCandidateGroupsFromVariable() {
        this.taskService.setVariable(this.task.getId(), "management", (Object)"management");
        this.taskService.setVariable(this.task.getId(), "accounting", (Object)"accounting");
        this.taskService.setVariable(this.task.getId(), "backoffice", (Object)"backoffice");
        ArrayList<String> aCandidateGroupList = new ArrayList<String>();
        aCandidateGroupList.add("${management}");
        aCandidateGroupList.add("${accounting}");
        aCandidateGroupList.add("${backoffice}");
        for (String candidateGroup : aCandidateGroupList) {
            Expression candidateGroupExpression = this.expressionManager.createExpression(candidateGroup);
            this.taskDefinition.addCandidateGroupIdExpression(candidateGroupExpression);
        }
        this.decorate(this.task, this.taskDecorator);
        Set candidates = this.task.getCandidates();
        TaskDecoratorTest.assertEquals((int)3, (int)candidates.size());
        for (IdentityLink identityLink : candidates) {
            String taskId = identityLink.getTaskId();
            TaskDecoratorTest.assertEquals((String)this.task.getId(), (String)taskId);
            TaskDecoratorTest.assertEquals((String)"candidate", (String)identityLink.getType());
            String groupId = identityLink.getGroupId();
            if ("management".equals(groupId)) {
                TaskDecoratorTest.assertEquals((String)"management", (String)groupId);
                continue;
            }
            if ("accounting".equals(groupId)) {
                TaskDecoratorTest.assertEquals((String)"accounting", (String)groupId);
                continue;
            }
            if ("backoffice".equals(groupId)) {
                TaskDecoratorTest.assertEquals((String)"backoffice", (String)groupId);
                continue;
            }
            TaskDecoratorTest.fail((String)("Unexpected group: " + groupId));
        }
    }

    protected class DeleteTaskCommand
    implements Command<Void> {
        protected TaskEntity task;

        public DeleteTaskCommand(TaskEntity task) {
            this.task = task;
        }

        public Void execute(CommandContext commandContext) {
            commandContext.getTaskManager().deleteTask(this.task, null, true);
            return null;
        }
    }

    protected class DecorateTaskCommand
    implements Command<Void> {
        protected TaskEntity task;
        protected TaskDecorator decorator;

        public DecorateTaskCommand(TaskEntity task, TaskDecorator decorator) {
            this.task = task;
            this.decorator = decorator;
        }

        public Void execute(CommandContext commandContext) {
            this.decorator.decorate(this.task, (VariableScope)this.task);
            return null;
        }
    }
}

