/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import org.camunda.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.TransitionInstanceImpl;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.TransitionInstance;
import org.junit.Assert;

public class ActivityInstanceAssert {
    public static ActivityInstanceTreeBuilder describeActivityInstanceTree() {
        return new ActivityInstanceTreeBuilder();
    }

    public static ActivityInstanceTreeBuilder describeActivityInstanceTree(String rootActivityId) {
        return new ActivityInstanceTreeBuilder(rootActivityId);
    }

    public static ActivityInstanceAssertThatClause assertThat(ActivityInstance actual) {
        return new ActivityInstanceAssertThatClause(actual);
    }

    public static class ActivityInstanceTreeBuilder {
        protected ActivityInstanceImpl rootInstance = null;
        protected Stack<ActivityInstanceImpl> activityInstanceStack = new Stack();

        public ActivityInstanceTreeBuilder() {
            this(null);
        }

        public ActivityInstanceTreeBuilder(String rootActivityId) {
            this.rootInstance = new ActivityInstanceImpl();
            this.rootInstance.setActivityId(rootActivityId);
            this.activityInstanceStack.push(this.rootInstance);
        }

        public ActivityInstanceTreeBuilder beginScope(String activityId) {
            ActivityInstanceImpl newInstance = new ActivityInstanceImpl();
            newInstance.setActivityId(activityId);
            ActivityInstanceImpl parentInstance = this.activityInstanceStack.peek();
            ArrayList<ActivityInstance> childInstances = new ArrayList<ActivityInstance>(Arrays.asList(parentInstance.getChildActivityInstances()));
            childInstances.add((ActivityInstance)newInstance);
            parentInstance.setChildActivityInstances(childInstances.toArray(new ActivityInstance[childInstances.size()]));
            this.activityInstanceStack.push(newInstance);
            return this;
        }

        public ActivityInstanceTreeBuilder beginMiBody(String activityId) {
            return this.beginScope(activityId + "#multiInstanceBody");
        }

        public ActivityInstanceTreeBuilder activity(String activityId) {
            this.beginScope(activityId);
            this.endScope();
            return this;
        }

        public ActivityInstanceTreeBuilder transition(String activityId) {
            TransitionInstanceImpl newInstance = new TransitionInstanceImpl();
            newInstance.setActivityId(activityId);
            ActivityInstanceImpl parentInstance = this.activityInstanceStack.peek();
            ArrayList<TransitionInstance> childInstances = new ArrayList<TransitionInstance>(Arrays.asList(parentInstance.getChildTransitionInstances()));
            childInstances.add((TransitionInstance)newInstance);
            parentInstance.setChildTransitionInstances(childInstances.toArray(new TransitionInstance[childInstances.size()]));
            return this;
        }

        public ActivityInstanceTreeBuilder endScope() {
            this.activityInstanceStack.pop();
            return this;
        }

        public ActivityInstance done() {
            return this.rootInstance;
        }
    }

    public static class ActivityInstanceAssertThatClause {
        protected ActivityInstance actual;

        public ActivityInstanceAssertThatClause(ActivityInstance actual) {
            this.actual = actual;
        }

        public void hasStructure(ActivityInstance expected) {
            this.assertTreeMatch(expected, this.actual);
        }

        protected void assertTreeMatch(ActivityInstance expected, ActivityInstance actual) {
            boolean treesMatch = this.isTreeMatched(expected, actual);
            if (!treesMatch) {
                Assert.fail((String)("Could not match expected tree \n" + expected + " \n\n with actual tree \n\n " + actual));
            }
        }

        protected boolean isTreeMatched(ActivityInstance actualInstance, ActivityInstance expectedInstance) {
            if (!expectedInstance.getActivityId().equals(actualInstance.getActivityId())) {
                return false;
            }
            if (expectedInstance.getChildActivityInstances().length != actualInstance.getChildActivityInstances().length) {
                return false;
            }
            ArrayList<ActivityInstance> unmatchedInstances = new ArrayList<ActivityInstance>(Arrays.asList(expectedInstance.getChildActivityInstances()));
            for (ActivityInstance child1 : actualInstance.getChildActivityInstances()) {
                boolean matchFound = false;
                for (ActivityInstance child2 : new ArrayList<ActivityInstance>(unmatchedInstances)) {
                    if (!this.isTreeMatched(child1, child2)) continue;
                    unmatchedInstances.remove(child2);
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                return false;
            }
            ArrayList<TransitionInstance> unmatchedTransitionInstances = new ArrayList<TransitionInstance>(Arrays.asList(expectedInstance.getChildTransitionInstances()));
            for (TransitionInstance child : actualInstance.getChildTransitionInstances()) {
                Iterator expectedTransitionInstanceIt = unmatchedTransitionInstances.iterator();
                boolean matchFound = false;
                while (expectedTransitionInstanceIt.hasNext() && !matchFound) {
                    TransitionInstance expectedChild = (TransitionInstance)expectedTransitionInstanceIt.next();
                    if (!expectedChild.getActivityId().equals(child.getActivityId())) continue;
                    matchFound = true;
                    expectedTransitionInstanceIt.remove();
                }
                if (matchFound) continue;
                return false;
            }
            return true;
        }
    }
}

