/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryProperty;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;

public class ProcessDefinitionQueryImpl
extends AbstractQuery<ProcessDefinitionQuery, ProcessDefinition>
implements ProcessDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected SuspensionState suspensionState;
    protected String authorizationUserId;
    protected String procDefId;
    protected String incidentType;
    protected String incidentId;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String eventSubscriptionName;
    protected String eventSubscriptionType;

    public ProcessDefinitionQueryImpl() {
    }

    public ProcessDefinitionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ProcessDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionId(String processDefinitionId) {
        this.id = processDefinitionId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionIdIn(String ... ids) {
        this.ids = ids;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategory(String category) {
        EnsureUtil.ensureNotNull("category", (Object)category);
        this.category = category;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionCategoryLike(String categoryLike) {
        EnsureUtil.ensureNotNull("categoryLike", (Object)categoryLike);
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionName(String name) {
        EnsureUtil.ensureNotNull("name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("nameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKey(String key) {
        EnsureUtil.ensureNotNull("key", (Object)key);
        this.key = key;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionKeyLike(String keyLike) {
        EnsureUtil.ensureNotNull("keyLike", (Object)keyLike);
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceName(String resourceName) {
        EnsureUtil.ensureNotNull("resourceName", (Object)resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionResourceNameLike(String resourceNameLike) {
        EnsureUtil.ensureNotNull("resourceNameLike", (Object)resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl processDefinitionVersion(Integer version) {
        EnsureUtil.ensurePositive("version", version);
        this.version = version;
        return this;
    }

    @Override
    public ProcessDefinitionQueryImpl latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public ProcessDefinitionQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public ProcessDefinitionQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscription(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    @Override
    public ProcessDefinitionQuery messageEventSubscriptionName(String messageName) {
        return this.eventSubscription("message", messageName);
    }

    public ProcessDefinitionQuery processDefinitionStarter(String procDefId) {
        this.procDefId = procDefId;
        return this;
    }

    public ProcessDefinitionQuery eventSubscription(String eventType, String eventName) {
        EnsureUtil.ensureNotNull("event type", (Object)eventType);
        EnsureUtil.ensureNotNull("event name", (Object)eventName);
        this.eventSubscriptionType = eventType;
        this.eventSubscriptionName = eventName;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incident type", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incident id", (Object)incidentId);
        this.incidentId = incidentId;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incident message", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public ProcessDefinitionQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incident messageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    public ProcessDefinitionQuery orderByDeploymentId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionKey() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionCategory() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionId() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionVersion() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
    }

    @Override
    public ProcessDefinitionQuery orderByProcessDefinitionName() {
        return (ProcessDefinitionQuery)this.orderBy(ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getProcessDefinitionManager().findProcessDefinitionCountByQueryCriteria(this);
    }

    @Override
    public List<ProcessDefinition> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        List<ProcessDefinition> list = commandContext.getProcessDefinitionManager().findProcessDefinitionsByQueryCriteria(this, page);
        for (ProcessDefinition processDefinition : list) {
            ProcessDefinitionEntity processDefinitionFromCache = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinition.getId());
            ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)processDefinition;
            processDefinitionEntity.setProperty("documentation", processDefinitionFromCache.getDescription());
        }
        return list;
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.version != null || this.deploymentId != null)) {
            throw new ProcessEngineException("Calling latest() can only be used in combination with key(String) and keyLike(String) or name(String) and nameLike(String)");
        }
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public SuspensionState getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(SuspensionState suspensionState) {
        this.suspensionState = suspensionState;
    }

    public String getIncidentId() {
        return this.incidentId;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    @Override
    public ProcessDefinitionQueryImpl startableByUser(String userId) {
        EnsureUtil.ensureNotNull("userId", (Object)userId);
        this.authorizationUserId = userId;
        return this;
    }
}

