/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessInstanceActivityInstantiationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.ActivityAfterInstantiationCmd;
import org.camunda.bpm.engine.impl.cmd.ActivityBeforeInstantiationCmd;
import org.camunda.bpm.engine.impl.cmd.ActivityCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.ActivityInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.ModifyProcessInstanceCmd;
import org.camunda.bpm.engine.impl.cmd.TransitionInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.TransitionInstantiationCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstanceActivityInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;

public class ProcessInstanceModificationBuilderImpl
implements ProcessInstanceModificationBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String processInstanceId;
    protected boolean skipCustomListeners = false;
    protected boolean skipIoMappings = false;
    protected List<AbstractProcessInstanceModificationCommand> operations = new ArrayList<AbstractProcessInstanceModificationCommand>();

    public ProcessInstanceModificationBuilderImpl(CommandExecutor commandExecutor, String processInstanceId) {
        this(processInstanceId);
        this.commandExecutor = commandExecutor;
    }

    public ProcessInstanceModificationBuilderImpl(CommandContext commandContext, String processInstanceId) {
        this(processInstanceId);
        this.commandContext = commandContext;
    }

    public ProcessInstanceModificationBuilderImpl(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ProcessInstanceModificationBuilder cancelActivityInstance(String activityInstanceId) {
        EnsureUtil.ensureNotNull("activityInstanceId", (Object)activityInstanceId);
        this.operations.add(new ActivityInstanceCancellationCmd(this.processInstanceId, activityInstanceId));
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder cancelTransitionInstance(String transitionInstanceId) {
        EnsureUtil.ensureNotNull("transitionInstanceId", (Object)transitionInstanceId);
        this.operations.add(new TransitionInstanceCancellationCmd(this.processInstanceId, transitionInstanceId));
        return this;
    }

    @Override
    public ProcessInstanceModificationBuilder cancelAllForActivity(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        this.operations.add(new ActivityCancellationCmd(this.processInstanceId, activityId));
        return this;
    }

    @Override
    public ProcessInstanceActivityInstantiationBuilder startBeforeActivity(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        ActivityBeforeInstantiationCmd currentInstantiation = new ActivityBeforeInstantiationCmd(this.processInstanceId, activityId);
        this.operations.add(currentInstantiation);
        return new ProcessInstanceActivityInstantiationBuilderImpl(this, currentInstantiation);
    }

    @Override
    public ProcessInstanceActivityInstantiationBuilder startBeforeActivity(String activityId, String ancestorActivityInstanceId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        EnsureUtil.ensureNotNull("ancestorActivityInstanceId", (Object)ancestorActivityInstanceId);
        ActivityBeforeInstantiationCmd currentInstantiation = new ActivityBeforeInstantiationCmd(this.processInstanceId, activityId, ancestorActivityInstanceId);
        this.operations.add(currentInstantiation);
        return new ProcessInstanceActivityInstantiationBuilderImpl(this, currentInstantiation);
    }

    @Override
    public ProcessInstanceActivityInstantiationBuilder startAfterActivity(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        ActivityAfterInstantiationCmd currentInstantiation = new ActivityAfterInstantiationCmd(this.processInstanceId, activityId);
        this.operations.add(currentInstantiation);
        return new ProcessInstanceActivityInstantiationBuilderImpl(this, currentInstantiation);
    }

    @Override
    public ProcessInstanceActivityInstantiationBuilder startAfterActivity(String activityId, String ancestorActivityInstanceId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        EnsureUtil.ensureNotNull("ancestorActivityInstanceId", (Object)ancestorActivityInstanceId);
        ActivityAfterInstantiationCmd currentInstantiation = new ActivityAfterInstantiationCmd(this.processInstanceId, activityId, ancestorActivityInstanceId);
        this.operations.add(currentInstantiation);
        return new ProcessInstanceActivityInstantiationBuilderImpl(this, currentInstantiation);
    }

    @Override
    public ProcessInstanceActivityInstantiationBuilder startTransition(String transitionId) {
        EnsureUtil.ensureNotNull("transitionId", (Object)transitionId);
        TransitionInstantiationCmd currentInstantiation = new TransitionInstantiationCmd(this.processInstanceId, transitionId);
        this.operations.add(currentInstantiation);
        return new ProcessInstanceActivityInstantiationBuilderImpl(this, currentInstantiation);
    }

    @Override
    public ProcessInstanceActivityInstantiationBuilder startTransition(String transitionId, String ancestorActivityInstanceId) {
        EnsureUtil.ensureNotNull("transitionId", (Object)transitionId);
        EnsureUtil.ensureNotNull("ancestorActivityInstanceId", (Object)ancestorActivityInstanceId);
        TransitionInstantiationCmd currentInstantiation = new TransitionInstantiationCmd(this.processInstanceId, transitionId, ancestorActivityInstanceId);
        this.operations.add(currentInstantiation);
        return new ProcessInstanceActivityInstantiationBuilderImpl(this, currentInstantiation);
    }

    @Override
    public void execute() {
        this.execute(false, false);
    }

    @Override
    public void execute(boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
        ModifyProcessInstanceCmd cmd = new ModifyProcessInstanceCmd(this);
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(cmd);
        } else {
            cmd.execute(this.commandContext);
        }
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public List<AbstractProcessInstanceModificationCommand> getModificationOperations() {
        return this.operations;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public boolean isSkipIoMappings() {
        return this.skipIoMappings;
    }
}

