/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.auth;

import java.util.ArrayList;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class DefaultAuthorizationProvider
implements ResourceAuthorizationProvider {
    @Override
    public AuthorizationEntity[] newUser(User user) {
        String userId = user.getId();
        AuthorizationEntity resourceOwnerAuthorization = this.createGrantAuthorization(userId, null, Resources.USER, userId, Permissions.ALL);
        return new AuthorizationEntity[]{resourceOwnerAuthorization};
    }

    @Override
    public AuthorizationEntity[] newGroup(Group group) {
        ArrayList<AuthorizationEntity> authorizations = new ArrayList<AuthorizationEntity>();
        String groupId = group.getId();
        AuthorizationEntity groupMemberAuthorization = this.createGrantAuthorization(null, groupId, Resources.GROUP, groupId, Permissions.READ);
        authorizations.add(groupMemberAuthorization);
        return authorizations.toArray(new AuthorizationEntity[0]);
    }

    @Override
    public AuthorizationEntity[] groupMembershipCreated(String groupId, String userId) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newFilter(Filter filter) {
        String owner = filter.getOwner();
        if (owner != null) {
            String filterId = filter.getId();
            AuthorizationEntity filterOwnerAuthorization = this.createGrantAuthorization(owner, null, Resources.FILTER, filterId, Permissions.ALL);
            return new AuthorizationEntity[]{filterOwnerAuthorization};
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newProcessDefinition(ProcessDefinition processDefinition) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newProcessInstance(ProcessInstance processInstance) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newTask(Task task) {
        return null;
    }

    @Override
    public AuthorizationEntity[] newTaskAssignee(Task task, String oldAssignee, String newAssignee) {
        if (newAssignee != null) {
            String taskId = task.getId();
            AuthorizationEntity authorization = this.getGrantAuthorizationByUserId(newAssignee, Resources.TASK, taskId);
            authorization = this.updateAuthorization(authorization, newAssignee, null, Resources.TASK, taskId, Permissions.READ, Permissions.UPDATE);
            return new AuthorizationEntity[]{authorization};
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newTaskOwner(Task task, String oldOwner, String newOwner) {
        if (newOwner != null) {
            String taskId = task.getId();
            AuthorizationEntity authorization = this.getGrantAuthorizationByUserId(newOwner, Resources.TASK, taskId);
            authorization = this.updateAuthorization(authorization, newOwner, null, Resources.TASK, taskId, Permissions.READ, Permissions.UPDATE);
            return new AuthorizationEntity[]{authorization};
        }
        return null;
    }

    @Override
    public AuthorizationEntity[] newTaskUserIdentityLink(Task task, String userId, String type) {
        String taskId = task.getId();
        AuthorizationEntity authorization = this.getGrantAuthorizationByUserId(userId, Resources.TASK, taskId);
        authorization = this.updateAuthorization(authorization, userId, null, Resources.TASK, taskId, Permissions.READ, Permissions.UPDATE);
        return new AuthorizationEntity[]{authorization};
    }

    @Override
    public AuthorizationEntity[] newTaskGroupIdentityLink(Task task, String groupId, String type) {
        String taskId = task.getId();
        AuthorizationEntity authorization = this.getGrantAuthorizationByGroupId(groupId, Resources.TASK, taskId);
        authorization = this.updateAuthorization(authorization, null, groupId, Resources.TASK, taskId, Permissions.READ, Permissions.UPDATE);
        return new AuthorizationEntity[]{authorization};
    }

    @Override
    public AuthorizationEntity[] deleteTaskUserIdentityLink(Task task, String userId, String type) {
        return null;
    }

    @Override
    public AuthorizationEntity[] deleteTaskGroupIdentityLink(Task task, String groupId, String type) {
        return null;
    }

    protected AuthorizationManager getAuthorizationManager() {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.getAuthorizationManager();
    }

    protected AuthorizationEntity getGrantAuthorizationByUserId(String userId, Resource resource, String resourceId) {
        AuthorizationManager authorizationManager = this.getAuthorizationManager();
        return authorizationManager.findAuthorizationByUserIdAndResourceId(1, userId, resource, resourceId);
    }

    protected AuthorizationEntity getGrantAuthorizationByGroupId(String groupId, Resource resource, String resourceId) {
        AuthorizationManager authorizationManager = this.getAuthorizationManager();
        return authorizationManager.findAuthorizationByGroupIdAndResourceId(1, groupId, resource, resourceId);
    }

    protected AuthorizationEntity updateAuthorization(AuthorizationEntity authorization, String userId, String groupId, Resource resource, String resourceId, Permission ... permissions) {
        if (authorization == null) {
            authorization = this.createGrantAuthorization(userId, groupId, resource, resourceId, new Permission[0]);
        }
        if (permissions != null) {
            for (Permission permission : permissions) {
                authorization.addPermission(permission);
            }
        }
        return authorization;
    }

    protected AuthorizationEntity createGrantAuthorization(String userId, String groupId, Resource resource, String resourceId, Permission ... permissions) {
        AuthorizationEntity authorization = new AuthorizationEntity(1);
        authorization.setUserId(userId);
        authorization.setGroupId(groupId);
        authorization.setResource(resource);
        authorization.setResourceId(resourceId);
        if (permissions != null) {
            for (Permission permission : permissions) {
                authorization.addPermission(permission);
            }
        }
        return authorization;
    }
}

