/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;

public abstract class AbstractInstanceCancellationCmd
extends AbstractProcessInstanceModificationCommand {
    public AbstractInstanceCancellationCmd(String processInstanceId) {
        super(processInstanceId);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity sourceInstanceExecution;
        ExecutionEntity topmostCancellableExecution = sourceInstanceExecution = this.determineSourceInstanceExecution(commandContext);
        ExecutionEntity parentScopeExecution = this.getParentScopeExecution(topmostCancellableExecution);
        while (parentScopeExecution != null && !topmostCancellableExecution.isConcurrent() && !topmostCancellableExecution.getParent().isConcurrent()) {
            topmostCancellableExecution = parentScopeExecution;
            parentScopeExecution = this.getParentScopeExecution(topmostCancellableExecution);
        }
        if (topmostCancellableExecution.isProcessInstanceExecution()) {
            topmostCancellableExecution.interrupt("Cancelled due to process instance modification", this.skipCustomListeners, this.skipIoMappings);
            topmostCancellableExecution.leaveActivityInstance();
            topmostCancellableExecution.setActivity(null);
        } else {
            topmostCancellableExecution.deleteCascade("Cancelled due to process instance modification", this.skipCustomListeners, this.skipIoMappings);
            topmostCancellableExecution.removeFromParentScope();
        }
        return null;
    }

    protected abstract ExecutionEntity determineSourceInstanceExecution(CommandContext var1);

    protected ExecutionEntity getParentScopeExecution(ExecutionEntity execution) {
        ExecutionEntity parent = execution.getParent();
        if (parent == null) {
            return null;
        }
        if (!parent.isScope()) {
            parent = parent.getParent();
        }
        return parent;
    }
}

