/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;

public abstract class AbstractSetJobStateCmd
extends AbstractSetStateCmd {
    protected String jobId;
    protected String jobDefinitionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;

    public AbstractSetJobStateCmd(String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey) {
        super(false, null);
        this.jobId = jobId;
        this.jobDefinitionId = jobDefinitionId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.jobId == null && this.jobDefinitionId == null && this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Job id, job definition id, process instance id, process definition id nor process definition key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.jobId != null) {
            final JobManager jobManager = commandContext.getJobManager();
            JobEntity job = commandContext.runWithoutAuthentication(new Callable<JobEntity>(){

                @Override
                public JobEntity call() throws Exception {
                    return jobManager.findJobById(AbstractSetJobStateCmd.this.jobId);
                }
            });
            job = jobManager.findJobById(this.jobId);
            if (job != null) {
                String processInstanceId = job.getProcessInstanceId();
                if (processInstanceId != null) {
                    authorizationManager.checkUpdateProcessInstanceById(processInstanceId);
                    return;
                }
                String processDefinitionKey = job.getProcessDefinitionKey();
                if (processDefinitionKey != null) {
                    authorizationManager.checkUpdateInstanceOnProcessDefinitionByKey(processDefinitionKey);
                    return;
                }
            }
        } else if (this.jobDefinitionId != null) {
            final JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
            JobDefinitionEntity jobDefinition = commandContext.runWithoutAuthentication(new Callable<JobDefinitionEntity>(){

                @Override
                public JobDefinitionEntity call() throws Exception {
                    return jobDefinitionManager.findById(AbstractSetJobStateCmd.this.jobDefinitionId);
                }
            });
            if (jobDefinition != null) {
                String processDefinitionKey = jobDefinition.getProcessDefinitionKey();
                authorizationManager.checkUpdateInstanceOnProcessDefinitionByKey(processDefinitionKey);
            }
        } else if (this.processInstanceId != null) {
            authorizationManager.checkUpdateProcessInstanceById(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            authorizationManager.checkUpdateInstanceOnProcessDefinitionById(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            authorizationManager.checkUpdateInstanceOnProcessDefinitionByKey(this.processDefinitionKey);
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        JobManager jobManager = commandContext.getJobManager();
        if (this.jobId != null) {
            jobManager.updateJobSuspensionStateById(this.jobId, suspensionState);
        } else if (this.jobDefinitionId != null) {
            jobManager.updateJobSuspensionStateByJobDefinitionId(this.jobDefinitionId, suspensionState);
        } else if (this.processInstanceId != null) {
            jobManager.updateJobSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            jobManager.updateJobSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            jobManager.updateJobSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), this.jobId, this.jobDefinitionId, this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }
}

