/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public class ActivityAfterInstantiationCmd
extends AbstractInstantiationCmd {
    protected String activityId;

    public ActivityAfterInstantiationCmd(String processInstanceId, String activityId) {
        this(processInstanceId, activityId, null);
    }

    public ActivityAfterInstantiationCmd(String processInstanceId, String activityId, String ancestorActivityInstanceId) {
        super(processInstanceId, ancestorActivityInstanceId);
        this.activityId = activityId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        ProcessDefinitionImpl processDefinition = processInstance.getProcessDefinition();
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        if (activity.getOutgoingTransitions().isEmpty()) {
            throw new ProcessEngineException("Cannot start after activity " + this.activityId + "; activity " + "has no outgoing sequence flow to take");
        }
        if (activity.getOutgoingTransitions().size() > 1) {
            throw new ProcessEngineException("Cannot start after activity " + this.activityId + "; " + "activity has more than one outgoing sequence flow");
        }
        return super.execute(commandContext);
    }

    @Override
    protected ScopeImpl getTargetFlowScope(ProcessDefinitionImpl processDefinition) {
        ActivityImpl sourceActivity = processDefinition.findActivity(this.activityId);
        TransitionImpl transition = (TransitionImpl)sourceActivity.getOutgoingTransitions().get(0);
        return transition.getDestination().getFlowScope();
    }

    @Override
    protected CoreModelElement getTargetElement(ProcessDefinitionImpl processDefinition) {
        ActivityImpl sourceActivity = processDefinition.findActivity(this.activityId);
        TransitionImpl transition = (TransitionImpl)sourceActivity.getOutgoingTransitions().get(0);
        return transition;
    }
}

