/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DelegateTaskCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String userId;

    public DelegateTaskCmd(String taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        final TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = commandContext.runWithoutAuthentication(new Callable<TaskEntity>(){

            @Override
            public TaskEntity call() throws Exception {
                return taskManager.findTaskById(DelegateTaskCmd.this.taskId);
            }
        });
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateTask(task);
        task.delegate(this.userId);
        task.createHistoricTaskDetails("Delegate");
        return null;
    }
}

