/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public class GetDeploymentCaseDiagramCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(GetDeploymentCaseDiagramCmd.class.getName());
    protected String caseDefinitionId;

    public GetDeploymentCaseDiagramCmd(String caseDefinitionId) {
        if (caseDefinitionId == null || caseDefinitionId.length() < 1) {
            throw new ProcessEngineException("The case definition id is mandatory, but '" + caseDefinitionId + "' has been provided.");
        }
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        CaseDefinitionEntity caseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
        String deploymentId = caseDefinition.getDeploymentId();
        String resourceName = caseDefinition.getDiagramResourceName();
        if (resourceName == null) {
            log.info("Resource name is null! No case diagram stream exists.");
            return null;
        }
        InputStream caseDiagramStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return caseDiagramStream;
    }
}

