/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class StartProcessInstanceCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;
    protected String caseInstanceId;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, String caseInstanceId, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.caseInstanceId = caseInstanceId;
        this.variables = variables;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = commandContext.runWithoutAuthentication(new Callable<ProcessDefinitionEntity>(){

            @Override
            public ProcessDefinitionEntity call() throws Exception {
                DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
                ProcessDefinitionEntity processDefinition = null;
                if (StartProcessInstanceCmd.this.processDefinitionId != null) {
                    processDefinition = deploymentCache.findDeployedProcessDefinitionById(StartProcessInstanceCmd.this.processDefinitionId);
                    EnsureUtil.ensureNotNull("No process definition found for id = '" + StartProcessInstanceCmd.this.processDefinitionId + "'", "processDefinition", (Object)processDefinition);
                } else if (StartProcessInstanceCmd.this.processDefinitionKey != null) {
                    processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(StartProcessInstanceCmd.this.processDefinitionKey);
                    EnsureUtil.ensureNotNull("No process definition found for key '" + StartProcessInstanceCmd.this.processDefinitionKey + "'", "processDefinition", (Object)processDefinition);
                } else {
                    throw new ProcessEngineException("processDefinitionKey and processDefinitionId are null");
                }
                return processDefinition;
            }
        });
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCreateProcessInstance(processDefinition);
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.businessKey, this.caseInstanceId);
        processInstance.start(this.variables);
        return processInstance;
    }
}

