/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.handler;

import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.form.TaskFormDataImpl;
import org.camunda.bpm.engine.impl.form.handler.DefaultFormHandler;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class DefaultTaskFormHandler
extends DefaultFormHandler
implements TaskFormHandler {
    @Override
    public TaskFormData createTaskForm(final TaskEntity task) {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication(this.deploymentId);
        if (targetProcessApplication != null) {
            return Context.executeWithinProcessApplication(new Callable<TaskFormData>(){

                @Override
                public TaskFormData call() throws Exception {
                    return DefaultTaskFormHandler.this.createTaskFormDataInternal(task);
                }
            }, targetProcessApplication);
        }
        return this.createTaskFormDataInternal(task);
    }

    protected TaskFormData createTaskFormDataInternal(TaskEntity task) {
        Object formValue;
        TaskFormDataImpl taskFormData = new TaskFormDataImpl();
        Expression formKey = task.getTaskDefinition().getFormKey();
        if (formKey != null && (formValue = formKey.getValue(task)) != null) {
            taskFormData.setFormKey(formValue.toString());
        }
        taskFormData.setDeploymentId(this.deploymentId);
        taskFormData.setTask(task);
        this.initializeFormProperties(taskFormData, task.getExecution());
        this.initializeFormFields(taskFormData, task.getExecution());
        return taskFormData;
    }
}

