/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceStart;

public class PvmAtomicOperationActivityInitStackNotifyListenerStart
extends PvmAtomicOperationActivityInstanceStart {
    @Override
    public String getCanonicalName() {
        return "activity-init-stack-notify-listener-start";
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            return activity;
        }
        PvmExecutionImpl parent = execution.getParent();
        if (parent != null) {
            return this.getScope(execution.getParent());
        }
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        ExecutionStartContext startContext = execution.getExecutionStartContext();
        InstantiationStack instantiationStack = startContext.getInstantiationStack();
        if (instantiationStack.getActivities().isEmpty() && instantiationStack.getTargetActivity() != null) {
            startContext.applyVariables(execution);
            execution.setActivity(instantiationStack.getTargetActivity());
            execution.performOperation(ACTIVITY_START_CREATE_SCOPE);
        } else if (instantiationStack.getActivities().isEmpty() && instantiationStack.getTargetTransition() != null) {
            PvmTransition transition = instantiationStack.getTargetTransition();
            startContext.applyVariables(execution);
            execution.setActivity(transition.getSource());
            execution.setTransition((TransitionImpl)transition);
            execution.performOperation(TRANSITION_START_NOTIFY_LISTENER_TAKE);
        } else {
            execution.setActivity(null);
            execution.performOperation(ACTIVITY_INIT_STACK);
        }
    }
}

