/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.tree;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.tree.Collector;

public abstract class TreeWalker<T> {
    protected T currentElement;
    protected List<Collector<T>> preCollectors = new ArrayList<Collector<T>>();
    protected List<Collector<T>> postCollectors = new ArrayList<Collector<T>>();

    protected abstract T nextElement();

    public TreeWalker(T initialElement) {
        this.currentElement = initialElement;
    }

    public TreeWalker<T> addPreCollector(Collector<T> collector) {
        this.preCollectors.add(collector);
        return this;
    }

    public TreeWalker<T> addPostCollector(Collector<T> collector) {
        this.postCollectors.add(collector);
        return this;
    }

    public void walkWhile() {
        this.walkWhile(new NullCondition());
    }

    public void walkUntil() {
        this.walkUntil(new NullCondition());
    }

    public T walkWhile(WalkCondition<T> condition) {
        while (!condition.isFulfilled(this.currentElement)) {
            for (Collector<T> collector : this.preCollectors) {
                collector.collect(this.currentElement);
            }
            this.currentElement = this.nextElement();
            for (Collector<T> collector : this.postCollectors) {
                collector.collect(this.currentElement);
            }
        }
        return this.getCurrentElement();
    }

    public T walkUntil(WalkCondition<T> condition) {
        do {
            for (Collector<T> collector : this.preCollectors) {
                collector.collect(this.currentElement);
            }
            this.currentElement = this.nextElement();
            for (Collector<T> collector : this.postCollectors) {
                collector.collect(this.currentElement);
            }
        } while (!condition.isFulfilled(this.currentElement));
        return this.getCurrentElement();
    }

    public T getCurrentElement() {
        return this.currentElement;
    }

    public class NullCondition<S>
    implements WalkCondition<S> {
        @Override
        public boolean isFulfilled(S element) {
            return element == null;
        }
    }

    public static interface WalkCondition<S> {
        public boolean isFulfilled(S var1);
    }
}

