/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Collection;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.PlanItem;

public class CmmnModelElementInstanceCmdTest
extends PluggableProcessEngineTestCase {
    private static final String CASE_KEY = "oneTaskCase";
    private String deploymentId;

    public void testRepositoryService() {
        this.deployTestCase();
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey(CASE_KEY).singleResult()).getId();
        CmmnModelInstance modelInstance = this.repositoryService.getCmmnModelInstance(caseDefinitionId);
        CmmnModelElementInstanceCmdTest.assertNotNull((Object)modelInstance);
        Collection humanTasks = modelInstance.getModelElementsByType(modelInstance.getModel().getType(HumanTask.class));
        CmmnModelElementInstanceCmdTest.assertEquals((int)1, (int)humanTasks.size());
        Collection planItems = modelInstance.getModelElementsByType(modelInstance.getModel().getType(PlanItem.class));
        CmmnModelElementInstanceCmdTest.assertEquals((int)1, (int)planItems.size());
        Collection cases = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Case.class));
        CmmnModelElementInstanceCmdTest.assertEquals((int)1, (int)cases.size());
    }

    private void deployTestCase() {
        String resource = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource(resource).deploy().getId();
    }

    public void tearDown() {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
    }
}

