/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProcessApplicationDeploymentTest
extends PluggableProcessEngineTestCase {
    private EmbeddedProcessApplication processApplication;

    protected void setUp() throws Exception {
        this.processApplication = new EmbeddedProcessApplication();
    }

    public void testSimpleProcessApplicationDeployment() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment);
    }

    public void testProcessApplicationDeploymentNoChanges() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationRegistration registration = deployment.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment);
    }

    public void testPartialChangesDeployAll() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)4L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        List processDefinitionsModel1 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)processDefinitionsModel1.size());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitionsModel1.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitionsModel1.get(1)).getVersion());
        List processDefinitionsModel2 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)processDefinitionsModel2.size());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitionsModel2.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitionsModel2.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testPartialChangesDeployChangedOnly() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        BpmnModelInstance changedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().done();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", changedModel2).deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessDefinition processDefinitionModel1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
        ProcessApplicationDeploymentTest.assertNotNull((Object)processDefinitionModel1);
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinitionModel1.getVersion());
        ProcessApplicationDeploymentTest.assertEquals((String)deployment1.getId(), (String)processDefinitionModel1.getDeploymentId());
        List processDefinitionsModel2 = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)processDefinitionsModel2.size());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitionsModel2.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitionsModel2.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        BpmnModelInstance anotherChangedModel2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
        ProcessApplicationDeployment deployment3 = this.repositoryService.createDeployment(this.processApplication.getReference()).enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", anotherChangedModel2).name("deployment").deploy();
        ProcessApplicationDeploymentTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").count());
        ProcessApplicationDeploymentTest.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").count());
        registration = deployment3.getProcessApplicationRegistration();
        deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)3, (int)deploymentIds.size());
        this.deleteDeployments(deployment1, deployment2, deployment3);
    }

    public void testPartialChangesResumePreviousVersion() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).deploy();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)registration.getDeploymentIds().size());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testProcessApplicationDeploymentResumePreviousVersions() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsDifferentKeys() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").resumePreviousVersions().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)deployment2.getId(), (String)((String)deploymentIds.iterator().next()));
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testProcessApplicationDeploymentNoResume() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentName() {
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml").deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(false).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addClasspathResource("org/camunda/bpm/engine/test/api/repository/version2.bpmn20.xml").deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment1, deployment2);
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameDeployDifferentProcesses() {
        BpmnModelInstance process1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance process2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn", process1).deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process2.bpmn", process2).deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment, deployment2);
    }

    public void testProcessApplicationDeploymentResumePreviousVersionsByDeploymentNameNoResume() {
        BpmnModelInstance process1 = Bpmn.createExecutableProcess((String)"process1").done();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn", process1).deploy();
        this.assertThatOneProcessIsDeployed();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("anotherDeployment").resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process2.bpmn", process1).deploy();
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        Set deploymentIds = registration.getDeploymentIds();
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)deploymentIds.size());
        ProcessApplicationDeploymentTest.assertEquals((String)deployment2.getId(), (String)((String)deploymentIds.iterator().next()));
        ProcessApplicationDeploymentTest.assertEquals((String)this.processEngine.getName(), (String)registration.getProcessEngineName());
        this.deleteDeployments(deployment, deployment2);
    }

    public void testPartialChangesResumePreviousVersionByDeploymentName() {
        BpmnModelInstance model1 = Bpmn.createExecutableProcess((String)"process1").done();
        BpmnModelInstance model2 = Bpmn.createExecutableProcess((String)"process2").done();
        ProcessApplicationDeployment deployment1 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").addModelInstance("process1.bpmn20.xml", model1).deploy();
        ProcessApplicationDeployment deployment2 = this.repositoryService.createDeployment(this.processApplication.getReference()).name("deployment").enableDuplicateFiltering(true).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").addModelInstance("process1.bpmn20.xml", model1).addModelInstance("process2.bpmn20.xml", model2).deploy();
        ProcessApplicationRegistration registration = deployment2.getProcessApplicationRegistration();
        ProcessApplicationDeploymentTest.assertEquals((int)2, (int)registration.getDeploymentIds().size());
        this.deleteDeployments(deployment1, deployment2);
    }

    private void deleteDeployments(ProcessApplicationDeployment ... deployments) {
        for (ProcessApplicationDeployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    private void assertThatOneProcessIsDeployed() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertThat((Object)processDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ProcessApplicationDeploymentTest.assertEquals((int)1, (int)processDefinition.getVersion());
    }
}

