/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class ProcessDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    private String deploymentOneId;
    private String deploymentTwoId;

    protected void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/two.bpmn20.xml").deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").deploy().getId();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    public void testProcessDefinitionProperties() {
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).orderByProcessDefinitionCategory().asc()).list();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)processDefinition.getKey());
        ProcessDefinitionQueryTest.assertEquals((String)"One", (String)processDefinition.getName());
        ProcessDefinitionQueryTest.assertEquals((String)"Desc one", (String)processDefinition.getDescription());
        ProcessDefinitionQueryTest.assertTrue((boolean)processDefinition.getId().startsWith("one:1"));
        ProcessDefinitionQueryTest.assertEquals((String)"Examples", (String)processDefinition.getCategory());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)processDefinition.getKey());
        ProcessDefinitionQueryTest.assertEquals((String)"One", (String)processDefinition.getName());
        ProcessDefinitionQueryTest.assertEquals((String)"Desc one", (String)processDefinition.getDescription());
        ProcessDefinitionQueryTest.assertTrue((boolean)processDefinition.getId().startsWith("one:2"));
        ProcessDefinitionQueryTest.assertEquals((String)"Examples", (String)processDefinition.getCategory());
        processDefinition = (ProcessDefinition)processDefinitions.get(2);
        ProcessDefinitionQueryTest.assertEquals((String)"two", (String)processDefinition.getKey());
        ProcessDefinitionQueryTest.assertEquals((String)"Two", (String)processDefinition.getName());
        ProcessDefinitionQueryTest.assertNull((Object)processDefinition.getDescription());
        ProcessDefinitionQueryTest.assertTrue((boolean)processDefinition.getId().startsWith("two:1"));
        ProcessDefinitionQueryTest.assertEquals((String)"Examples2", (String)processDefinition.getCategory());
    }

    public void testQueryByDeploymentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().deploymentId(this.deploymentOneId);
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidDeploymentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().deploymentId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().deploymentId(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("Two");
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("One");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidName() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionName(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%w%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidNameLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one");
        this.verifyQueryResults(query, 2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidKey() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByKeyLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%o%");
        this.verifyQueryResults(query, 3);
    }

    public void testQueryByInvalidKeyLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionKeyLike(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByCategory() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategory("Examples");
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByCategoryLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%Example%");
        this.verifyQueryResults(query, 3);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionCategoryLike("%amples2");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 2);
    }

    public void testQueryByInvalidVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(-1)).list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(null).list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByKeyAndVersion() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(1));
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(2));
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").processDefinitionVersion(Integer.valueOf(3));
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByLatest() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().latestVersion();
        this.verifyQueryResults(query, 2);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").latestVersion();
        this.verifyQueryResults(query, 1);
        query = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("two").latestVersion();
        this.verifyQueryResults(query, 1);
    }

    public void testInvalidUsageOfLatest() {
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionId("test").latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(1)).latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.repositoryService.createProcessDefinitionQuery().deploymentId("test").latestVersion().list();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQuerySorting() {
        ProcessDefinitionQuery query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionId().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentId().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().desc();
        this.verifyQueryResults(query, 3);
        query = (ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc();
        List processDefinitions = query.list();
        ProcessDefinitionQueryTest.assertEquals((int)3, (int)processDefinitions.size());
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
        ProcessDefinitionQueryTest.assertEquals((int)2, (int)((ProcessDefinition)processDefinitions.get(0)).getVersion());
        ProcessDefinitionQueryTest.assertEquals((String)"one", (String)((ProcessDefinition)processDefinitions.get(1)).getKey());
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(1)).getVersion());
        ProcessDefinitionQueryTest.assertEquals((String)"two", (String)((ProcessDefinition)processDefinitions.get(2)).getKey());
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)((ProcessDefinition)processDefinitions.get(2)).getVersion());
    }

    private void verifyQueryResults(ProcessDefinitionQuery query, int countExpected) {
        ProcessDefinitionQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        ProcessDefinitionQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            ProcessDefinitionQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            ProcessDefinitionQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(ProcessDefinitionQuery query) {
        try {
            query.singleResult();
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByMessageSubscription() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/processWithNewBookingMessage.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/repository/processWithNewInvoiceMessage.bpmn20.xml").deploy();
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("newInvoiceMessage").count());
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("newBookingMessage").count());
        ProcessDefinitionQueryTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().messageEventSubscriptionName("bogus").count());
        this.repositoryService.deleteDeployment(deployment.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentId() {
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentId(incident.getId());
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidIncidentId() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query.incidentId("invalid"), 0);
        try {
            query.incidentId(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentType() {
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentType(incident.getIncidentType());
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidIncidentType() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query.incidentType("invalid"), 0);
        try {
            query.incidentType(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessage() {
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)incidentList.size());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentMessage(incident.getIncidentMessage());
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidIncidentMessage() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query.incidentMessage("invalid"), 0);
        try {
            query.incidentMessage(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/repository/failingProcessCreateOneIncident.bpmn20.xml"})
    public void testQueryByIncidentMessageLike() {
        ProcessDefinitionQueryTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("failingProcess").count());
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidentList = this.runtimeService.createIncidentQuery().list();
        ProcessDefinitionQueryTest.assertEquals((int)1, (int)incidentList.size());
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().incidentMessageLike("%expected%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidIncidentMessageLike() {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        this.verifyQueryResults(query.incidentMessageLike("invalid"), 0);
        try {
            query.incidentMessageLike(null);
            ProcessDefinitionQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByProcessDefinitionIds() {
        ProcessDefinitionQueryTest.assertTrue((boolean)this.repositoryService.createProcessDefinitionQuery().processDefinitionIdIn(new String[]{"a", "b"}).list().isEmpty());
        List list = this.repositoryService.createProcessDefinitionQuery().list();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((ProcessDefinition)list.get(i)).getId();
        }
        List idInList = this.repositoryService.createProcessDefinitionQuery().processDefinitionIdIn(ids).list();
        for (ProcessDefinition processDefinition : idInList) {
            boolean found = false;
            for (ProcessDefinition otherProcessDefinition : list) {
                if (!otherProcessDefinition.getId().equals(processDefinition.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ProcessDefinitionQueryTest.fail((String)("Expected to find process definition " + processDefinition));
        }
    }

    public void testQueryByLatestAndName() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionName("First Test Process").latestVersion();
        this.verifyQueryResults(query, 1);
        ProcessDefinition result = (ProcessDefinition)query.singleResult();
        ProcessDefinitionQueryTest.assertEquals((String)"First Test Process", (String)result.getName());
        ProcessDefinitionQueryTest.assertEquals((int)2, (int)result.getVersion());
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    public void testQueryByLatestAndName_NotFound() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/second-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionName("First Test Process").latestVersion();
        this.verifyQueryResults(query, 0);
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    public void testQueryByLatestAndNameLike() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/second-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionNameLike("%Test Process").latestVersion();
        this.verifyQueryResults(query, 1);
        ProcessDefinition result = (ProcessDefinition)query.singleResult();
        ProcessDefinitionQueryTest.assertEquals((String)"Second Test Process", (String)result.getName());
        ProcessDefinitionQueryTest.assertEquals((int)2, (int)result.getVersion());
        query.processDefinitionNameLike("%Test%").latestVersion();
        this.verifyQueryResults(query, 1);
        result = (ProcessDefinition)query.singleResult();
        ProcessDefinitionQueryTest.assertEquals((String)"Second Test Process", (String)result.getName());
        ProcessDefinitionQueryTest.assertEquals((int)2, (int)result.getVersion());
        query.processDefinitionNameLike("Second%").latestVersion();
        result = (ProcessDefinition)query.singleResult();
        ProcessDefinitionQueryTest.assertEquals((String)"Second Test Process", (String)result.getName());
        ProcessDefinitionQueryTest.assertEquals((int)2, (int)result.getVersion());
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }

    public void testQueryByLatestAndNameLike_NotFound() {
        String firstDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/first-process.bpmn20.xml").deploy().getId();
        String secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/second-process.bpmn20.xml").deploy().getId();
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery();
        query.processDefinitionNameLike("First%").latestVersion();
        this.verifyQueryResults(query, 0);
        this.repositoryService.deleteDeployment(firstDeployment, true);
        this.repositoryService.deleteDeployment(secondDeployment, true);
    }
}

