/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.TransitionInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.examples.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.variable.Variables;

public class ProcessInstanceModificationAsyncTest
extends PluggableProcessEngineTestCase {
    protected static final String EXCLUSIVE_GATEWAY_ASYNC_BEFORE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";
    protected static final String ASYNC_BEFORE_ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneTaskProcess.bpmn20.xml";
    protected static final String ASYNC_BEFORE_ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_BEFORE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_BEFORE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_PARALLEL_ASYNC_BEFORE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_BEFORE_IO_LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcessIoAndListeners.bpmn20.xml";
    protected static final String ASYNC_AFTER_ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_AFTER_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_ASYNC_AFTER_END_EVENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterEndEventProcess.bpmn20.xml";
    protected static final String ASYNC_AFTER_FAILING_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterFailingTaskProcess.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    public void testStartBeforeAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task2")).execute();
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        ProcessInstanceModificationAsyncTest.assertNull((Object)task);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)updatedTree);
        ProcessInstanceModificationAsyncTest.assertEquals((String)processInstanceId, (String)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)job);
        this.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)task);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        this.completeTasksInOrder("task1", "task2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testStartAfterAsync() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exclusiveGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startAfterActivity("task2")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)job);
        Execution jobExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("end2").executionId(job.getExecutionId()).singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)jobExecution);
        this.completeTasksInOrder("task1");
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    public void testCancelParentScopeOfAsyncBeforeActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneScopeTaskProcess.bpmn20.xml"})
    public void testCancelParentScopeOfAsyncBeforeScopeActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    public void testCancelParentScopeOfParallelAsyncBeforeScopeActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedConcurrentTasksProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    public void testCancelAsyncActivityInstanceFails() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
            ProcessInstanceModificationAsyncTest.fail((String)"should not succeed");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("activityInstance is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    public void testCancelAsyncBeforeTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
        ProcessInstanceModificationAsyncTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneTaskProcess.bpmn20.xml"})
    public void testCancelAsyncBeforeTransitionInstanceEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneScopeTaskProcess.bpmn20.xml"})
    public void testCancelAsyncBeforeScopeTransitionInstanceEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncBeforeOneTaskProcess.bpmn20.xml"})
    public void testCancelAndStartAsyncBeforeTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        Job asyncJob = (Job)this.managementService.createJobQuery().singleResult();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).startBeforeActivity("theTask")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("theTask").done());
        Job newAsyncJob = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertFalse((boolean)asyncJob.getId().equals(newAsyncJob.getId()));
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        this.executeAvailableJobs();
        this.completeTasksInOrder("theTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    public void testCancelNestedConcurrentTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedConcurrentTasksProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask1").getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").transition("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        Job innerTask2Job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)innerTask2Job);
        Execution innerTask2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("innerTask2").singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)innerTask2Execution);
        ProcessInstanceModificationAsyncTest.assertEquals((String)innerTask2Job.getExecutionId(), (String)innerTask2Execution.getId());
        this.completeTasksInOrder("outerTask");
        this.managementService.executeJob(innerTask2Job.getId());
        this.completeTasksInOrder("innerTask2");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeConcurrentScopeTaskProcess.bpmn20.xml"})
    public void testCancelNestedConcurrentTransitionInstanceWithConcurrentScopeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedConcurrentTasksProcess");
        String processInstanceId = processInstance.getId();
        Job innerTask2Job = (Job)this.managementService.createJobQuery().activityId("innerTask2").singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)innerTask2Job);
        this.managementService.executeJob(innerTask2Job.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask1").getId()).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask2").scope().done());
        ProcessInstanceModificationAsyncTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().activityId("innerTask1").count());
        this.completeTasksInOrder("innerTask2", "outerTask");
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcessIoAndListeners.bpmn20.xml"})
    public void FAILING_testCancelTransitionInstanceShouldNotInvokeIoMappingAndListenersOfTargetActivity() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
        ProcessInstanceModificationAsyncTest.assertTrue((boolean)RecorderExecutionListener.getRecordedEvents().isEmpty());
        ProcessInstanceModificationAsyncTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("outputMappingExecuted").count());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterOneTaskProcess.bpmn20.xml"})
    public void testCancelAsyncAfterTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        Task innerTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask").singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)innerTask);
        this.taskService.complete(innerTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "innerTask").getId()).execute();
        ProcessInstanceModificationAsyncTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncAfterEndEventProcess.bpmn20.xml"})
    public void testCancelAsyncAfterEndEventTransitionInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedAsyncEndEventProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ProcessInstanceModificationAsyncTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "subProcessEnd").getId()).execute();
        ProcessInstanceModificationAsyncTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterOneTaskProcess.bpmn20.xml"})
    public void testCancelAsyncAfterTransitionInstanceEndsProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "theTask").getId()).execute();
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testCancelAsyncAfterTransitionInstanceInvokesParentListeners() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess", (Map)Variables.createVariables().putValue("listener", (Object)new RecorderExecutionListener()));
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelTransitionInstance(this.getChildTransitionInstanceForTargetActivity(tree, "subProcessEnd").getId()).execute();
        ProcessInstanceModificationAsyncTest.assertEquals((int)1, (int)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent event = RecorderExecutionListener.getRecordedEvents().get(0);
        ProcessInstanceModificationAsyncTest.assertEquals((String)"subProcess", (String)event.getActivityId());
        RecorderExecutionListener.clear();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelAsyncBeforeOneTaskProcess.bpmn20.xml"})
    public void testCancelAllCancelsTransitionInstances() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        ProcessInstanceModificationAsyncTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("innerTask").execute();
        ProcessInstanceModificationAsyncTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        this.completeTasksInOrder("outerTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterFailingTaskProcess.bpmn20.xml"})
    public void testStartBeforeAsyncAfterTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingAfterAsyncTask");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)job);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("task1").transition("task1").done());
        this.executeAvailableJobs();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("task1").transition("task1").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.asyncAfterFailingTaskProcess.bpmn20.xml"})
    public void testStartBeforeAsyncAfterTaskActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingAfterAsyncTask");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstanceModificationAsyncTest.assertNotNull((Object)job);
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeFailedJobs().includeIncidents().list();
        ProcessInstanceModificationAsyncTest.assertEquals((int)1, (int)statistics.size());
        ProcessInstanceModificationAsyncTest.assertEquals((String)"task1", (String)((ActivityStatistics)statistics.get(0)).getId());
        ProcessInstanceModificationAsyncTest.assertEquals((int)0, (int)((ActivityStatistics)statistics.get(0)).getFailedJobs());
        ProcessInstanceModificationAsyncTest.assertEquals((int)0, (int)((ActivityStatistics)statistics.get(0)).getIncidentStatistics().size());
        ProcessInstanceModificationAsyncTest.assertEquals((int)1, (int)((ActivityStatistics)statistics.get(0)).getInstances());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).execute();
        statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).includeFailedJobs().includeIncidents().list();
        ProcessInstanceModificationAsyncTest.assertEquals((int)1, (int)statistics.size());
        ProcessInstanceModificationAsyncTest.assertEquals((String)"task1", (String)((ActivityStatistics)statistics.get(0)).getId());
        ProcessInstanceModificationAsyncTest.assertEquals((int)0, (int)((ActivityStatistics)statistics.get(0)).getFailedJobs());
        ProcessInstanceModificationAsyncTest.assertEquals((int)0, (int)((ActivityStatistics)statistics.get(0)).getIncidentStatistics().size());
        ProcessInstanceModificationAsyncTest.assertEquals((int)2, (int)((ActivityStatistics)statistics.get(0)).getInstances());
        this.executeAvailableJobs();
    }

    protected String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    protected ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected TransitionInstance getChildTransitionInstanceForTargetActivity(ActivityInstance activityInstance, String targetActivityId) {
        for (TransitionInstance transitionInstance : activityInstance.getChildTransitionInstances()) {
            if (!targetActivityId.equals(transitionInstance.getActivityId())) continue;
            return transitionInstance;
        }
        for (TransitionInstance transitionInstance : activityInstance.getChildActivityInstances()) {
            TransitionInstance instance = this.getChildTransitionInstanceForTargetActivity((ActivityInstance)transitionInstance, targetActivityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstanceModificationAsyncTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

