/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class MessageIntermediateEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testSingleIntermediateMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        String messageName = "newInvoiceMessage";
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)execution);
        this.runtimeService.messageEventReceived(messageName, execution.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    @Deployment
    public void testConcurrentIntermediateMessageEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)2, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch1"));
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch2"));
        String messageName = "newInvoiceMessage";
        List executions = this.runtimeService.createExecutionQuery().messageEventSubscriptionName(messageName).list();
        MessageIntermediateEventTest.assertNotNull((Object)executions);
        MessageIntermediateEventTest.assertEquals((int)2, (int)executions.size());
        this.runtimeService.messageEventReceived(messageName, ((Execution)executions.get(0)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNull((Object)task);
        this.runtimeService.messageEventReceived(messageName, ((Execution)executions.get(1)).getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        MessageIntermediateEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
    }

    public void testIntermediateMessageEventRedeployment() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml").deploy();
        MessageIntermediateEventTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testSingleIntermediateMessageEvent.bpmn20.xml").deploy();
        MessageIntermediateEventTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        activeActivityIds = this.runtimeService.getActiveActivityIds(pi.getId());
        MessageIntermediateEventTest.assertNotNull((Object)activeActivityIds);
        MessageIntermediateEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        MessageIntermediateEventTest.assertTrue((boolean)activeActivityIds.contains("messageCatch"));
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    public void testEmptyMessageNameFails() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/event/message/MessageIntermediateEventTest.testEmptyMessageNameFails.bpmn20.xml").deploy();
            MessageIntermediateEventTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            MessageIntermediateEventTest.assertTrue((boolean)e.getMessage().contains("Cannot have a message event subscription with an empty or missing name"));
        }
    }
}

