/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.iomapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.iomapping.OnePlusOneBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class InputOutputTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testInputNullValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((String)"null", (String)variable.getTypeName());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputStringConstantValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)"stringValue", (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputElValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2L, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptSource", "return 1 + 1");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputExternalScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputExternalScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputExternalScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputExternalClasspathScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputExternalClasspathScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "classpath://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputExternalClasspathScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputExternalDeploymentScriptValue.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    public void testInputExternalDeploymentScriptValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputExternalDeploymentScriptValueAsVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    public void testInputExternalDeploymentScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "deployment://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInputExternalDeploymentScriptValueAsBean.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    public void testInputExternalDeploymentScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testInputListElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get(0));
        InputOutputTest.assertEquals((Object)3L, value.get(1));
        InputOutputTest.assertEquals((Object)4L, value.get(2));
    }

    @Deployment
    public void testInputListMixedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)"constantStringValue", value.get(0));
        InputOutputTest.assertEquals((Object)"elValue", value.get(1));
        InputOutputTest.assertEquals((Object)"scriptValue", value.get(2));
    }

    @Deployment
    public void testInputMapElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get("a"));
        InputOutputTest.assertEquals((Object)3L, value.get("b"));
        InputOutputTest.assertEquals((Object)4L, value.get("c"));
    }

    @Deployment
    public void testInputMultipleElValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)3L, (Object)var2.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testInputMultipleMixedValue() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testInputNested() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("wait").singleResult();
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        TreeMap value = (TreeMap)var1.getValue();
        List nestedList = (List)value.get("a");
        InputOutputTest.assertEquals((Object)"stringInListNestedInMap", nestedList.get(0));
        InputOutputTest.assertEquals((Object)"b", nestedList.get(1));
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)execution.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testInputNestedListValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)"constantStringValue", value.get(0));
        InputOutputTest.assertEquals((Object)"elValue", value.get(1));
        InputOutputTest.assertEquals((Object)"scriptValue", value.get(2));
        List nestedList = (List)value.get(3);
        List nestedNestedList = (List)nestedList.get(0);
        InputOutputTest.assertEquals((Object)"a", nestedNestedList.get(0));
        InputOutputTest.assertEquals((Object)"b", nestedNestedList.get(1));
        InputOutputTest.assertEquals((Object)"c", nestedNestedList.get(2));
        InputOutputTest.assertEquals((Object)"d", nestedList.get(1));
        TreeMap nestedMap = (TreeMap)value.get(4);
        InputOutputTest.assertEquals((Object)"bar", nestedMap.get("foo"));
        InputOutputTest.assertEquals((Object)"world", nestedMap.get("hello"));
    }

    @Deployment
    public void testOutputNullValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((String)"null", (String)variable.getTypeName());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputStringConstantValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)"stringValue", (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputElValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2L, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptSource", "return 1 + 1");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputExternalScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputExternalScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputExternalScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputExternalClasspathScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputExternalClasspathScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "classpath://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputExternalClasspathScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputExternalDeploymentScriptValue.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    public void testOutputExternalDeploymentScriptValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputExternalDeploymentScriptValueAsVariable.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    public void testOutputExternalDeploymentScriptValueAsVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("scriptPath", "deployment://org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testOutputExternalDeploymentScriptValueAsBean.bpmn", "org/camunda/bpm/engine/test/bpmn/iomapping/oneplusone.groovy"})
    public void testOutputExternalDeploymentScriptValueAsBean() {
        HashMap<String, OnePlusOneBean> variables = new HashMap<String, OnePlusOneBean>();
        variables.put("onePlusOneBean", new OnePlusOneBean());
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        InputOutputTest.assertEquals((Object)2, (Object)variable.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)variable.getExecutionId());
    }

    @Deployment
    public void testOutputListElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get(0));
        InputOutputTest.assertEquals((Object)3L, value.get(1));
        InputOutputTest.assertEquals((Object)4L, value.get(2));
    }

    @Deployment
    public void testOutputListMixedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)"constantStringValue", value.get(0));
        InputOutputTest.assertEquals((Object)"elValue", value.get(1));
        InputOutputTest.assertEquals((Object)"scriptValue", value.get(2));
    }

    @Deployment
    public void testOutputMapElValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        TreeMap value = (TreeMap)variable.getValue();
        InputOutputTest.assertEquals((Object)2L, value.get("a"));
        InputOutputTest.assertEquals((Object)3L, value.get("b"));
        InputOutputTest.assertEquals((Object)4L, value.get("c"));
    }

    @Deployment
    public void testOutputMultipleElValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)3L, (Object)var2.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testOutputMultipleMixedValue() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)var1);
        InputOutputTest.assertEquals((Object)2L, (Object)var1.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testOutputNested() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance var1 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        TreeMap value = (TreeMap)var1.getValue();
        List nestedList = (List)value.get("a");
        InputOutputTest.assertEquals((Object)"stringInListNestedInMap", nestedList.get(0));
        InputOutputTest.assertEquals((Object)"b", nestedList.get(1));
        InputOutputTest.assertEquals((String)pi.getId(), (String)var1.getExecutionId());
        VariableInstance var2 = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var2").singleResult();
        InputOutputTest.assertNotNull((Object)var2);
        InputOutputTest.assertEquals((Object)"stringConstantValue", (Object)var2.getValue());
        InputOutputTest.assertEquals((String)pi.getId(), (String)var2.getExecutionId());
    }

    @Deployment
    public void testOutputListNestedValues() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName("var1").singleResult();
        InputOutputTest.assertNotNull((Object)variable);
        List value = (List)variable.getValue();
        InputOutputTest.assertEquals((Object)"constantStringValue", value.get(0));
        InputOutputTest.assertEquals((Object)"elValue", value.get(1));
        InputOutputTest.assertEquals((Object)"scriptValue", value.get(2));
        List nestedList = (List)value.get(3);
        List nestedNestedList = (List)nestedList.get(0);
        InputOutputTest.assertEquals((Object)"a", nestedNestedList.get(0));
        InputOutputTest.assertEquals((Object)"b", nestedNestedList.get(1));
        InputOutputTest.assertEquals((Object)"c", nestedNestedList.get(2));
        InputOutputTest.assertEquals((Object)"d", nestedList.get(1));
        TreeMap nestedMap = (TreeMap)value.get(4);
        InputOutputTest.assertEquals((Object)"bar", nestedMap.get("foo"));
        InputOutputTest.assertEquals((Object)"world", nestedMap.get("hello"));
    }

    public void testInterruptingEventSubprocessIoSupport() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testInterruptingEventSubprocessIoSupport.bpmn").deploy();
            InputOutputTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("camunda:inputOutput mapping unsupported for element type 'subProcess' with attribute 'triggeredByEvent = true'", e.getMessage());
        }
    }

    @Deployment
    public void testSubprocessIoSupport() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("processVar", "value");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Execution subprocessExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subprocessTask").singleResult();
        Map variablesLocal = this.runtimeService.getVariablesLocal(subprocessExecution.getId());
        InputOutputTest.assertEquals((int)1, (int)variablesLocal.size());
        InputOutputTest.assertEquals((Object)"value", variablesLocal.get("innerVar"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        String outerVariable = (String)this.runtimeService.getVariableLocal(processInstance.getId(), "outerVar");
        InputOutputTest.assertNotNull((Object)outerVariable);
        InputOutputTest.assertEquals((String)"value", (String)outerVariable);
    }

    @Deployment
    public void testSequentialMIActivityIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialActivity", variables);
        Execution miExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").singleResult();
        InputOutputTest.assertNotNull((Object)miExecution);
        InputOutputTest.assertFalse((boolean)instance.getId().equals(miExecution.getId()));
        InputOutputTest.assertEquals((Object)0, (Object)this.runtimeService.getVariable(miExecution.getId(), "loopCounter"));
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        InputOutputTest.assertEquals((Object)1, (Object)this.runtimeService.getVariableLocal(miExecution.getId(), "miCounterValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        miExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").singleResult();
        InputOutputTest.assertNotNull((Object)miExecution);
        InputOutputTest.assertFalse((boolean)instance.getId().equals(miExecution.getId()));
        InputOutputTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(miExecution.getId(), "loopCounter"));
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        InputOutputTest.assertEquals((Object)2, (Object)this.runtimeService.getVariableLocal(miExecution.getId(), "miCounterValue"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Deployment
    public void testSequentialMISubprocessIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess", variables);
        Execution miScopeExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        InputOutputTest.assertNotNull((Object)miScopeExecution);
        InputOutputTest.assertEquals((Object)0, (Object)this.runtimeService.getVariable(miScopeExecution.getId(), "loopCounter"));
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        InputOutputTest.assertEquals((Object)1, (Object)this.runtimeService.getVariableLocal(miScopeExecution.getId(), "miCounterValue"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        miScopeExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        InputOutputTest.assertNotNull((Object)miScopeExecution);
        InputOutputTest.assertFalse((boolean)instance.getId().equals(miScopeExecution.getId()));
        InputOutputTest.assertEquals((Object)1, (Object)this.runtimeService.getVariable(miScopeExecution.getId(), "loopCounter"));
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        InputOutputTest.assertEquals((Object)2, (Object)this.runtimeService.getVariableLocal(miScopeExecution.getId(), "miCounterValue"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Deployment
    public void testParallelMIActivityIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miParallelActivity", variables);
        Execution miExecution1 = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").variableValueEquals("loopCounter", (Object)0).singleResult();
        InputOutputTest.assertNotNull((Object)miExecution1);
        InputOutputTest.assertFalse((boolean)instance.getId().equals(miExecution1.getId()));
        InputOutputTest.assertEquals((Object)1, (Object)this.runtimeService.getVariableLocal(miExecution1.getId(), "miCounterValue"));
        Execution miExecution2 = (Execution)this.runtimeService.createExecutionQuery().activityId("miTask").variableValueEquals("loopCounter", (Object)1).singleResult();
        InputOutputTest.assertNotNull((Object)miExecution2);
        InputOutputTest.assertFalse((boolean)instance.getId().equals(miExecution2.getId()));
        InputOutputTest.assertEquals((Object)2, (Object)this.runtimeService.getVariableLocal(miExecution2.getId(), "miCounterValue"));
        InputOutputTest.assertEquals((long)2L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    @Deployment
    public void testParallelMISubprocessIoSupport() {
        HashMap<String, Number> variables = new HashMap<String, Number>();
        variables.put("counter", new AtomicInteger());
        variables.put("nrOfLoops", 2);
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess", variables);
        Execution miScopeExecution1 = (Execution)this.runtimeService.createExecutionQuery().activityId("task").variableValueEquals("loopCounter", (Object)0).singleResult();
        InputOutputTest.assertNotNull((Object)miScopeExecution1);
        InputOutputTest.assertEquals((Object)1, (Object)this.runtimeService.getVariableLocal(miScopeExecution1.getId(), "miCounterValue"));
        Execution miScopeExecution2 = (Execution)this.runtimeService.createExecutionQuery().activityId("task").variableValueEquals("loopCounter", (Object)1).singleResult();
        InputOutputTest.assertNotNull((Object)miScopeExecution2);
        InputOutputTest.assertFalse((boolean)instance.getId().equals(miScopeExecution2.getId()));
        InputOutputTest.assertEquals((Object)2, (Object)this.runtimeService.getVariableLocal(miScopeExecution2.getId(), "miCounterValue"));
        InputOutputTest.assertEquals((long)2L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("miCounterValue").count());
    }

    public void testMIOutputMappingDisallowed() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testMIOutputMappingDisallowed.bpmn20.xml").deploy();
            InputOutputTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("camunda:outputParameter not allowed for multi-instance constructs", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    public void FAILING_testBpmnErrorInScriptInputMapping() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("throwInMapping", "in");
        variables.put("exception", (Object)new BpmnError("error"));
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"User Task"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    public void testExceptionInScriptInputMapping() {
        String exceptionMessage = "myException";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("throwInMapping", "in");
        variables.put("exception", new RuntimeException(exceptionMessage));
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        }
        catch (RuntimeException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)exceptionMessage));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    public void FAILING_testBpmnErrorInScriptOutputMapping() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("throwInMapping", "out");
        variables.put("exception", (Object)new BpmnError("error"));
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"User Task"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/iomapping/InputOutputTest.testThrowErrorInScriptInputOutputMapping.bpmn"})
    public void testExceptionInScriptOutputMapping() {
        String exceptionMessage = "myException";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("throwInMapping", "out");
        variables.put("exception", new RuntimeException(exceptionMessage));
        try {
            this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        }
        catch (RuntimeException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)exceptionMessage));
        }
    }

    @Deployment
    public void FAILING_testOutputMappingOnErrorBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"taskOk", (String)task.getTaskDefinitionKey());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localNotMapped").count());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localMapped").count());
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("throwError", true));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"taskError", (String)task.getTaskDefinitionKey());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localNotMapped").count());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("localMapped").count());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void FAILING_testOutputMappingOnMessageBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"wait", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"taskOk", (String)task.getTaskDefinitionKey());
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("throwError", true));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"wait", (String)task.getTaskDefinitionKey());
        this.runtimeService.correlateMessage("message");
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"taskError", (String)task.getTaskDefinitionKey());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void FAILING_testOutputMappingOnTimerBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"wait", (String)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"taskOk", (String)task.getTaskDefinitionKey());
        InputOutputTest.assertEquals((long)1L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.runtimeService.startProcessInstanceByKey("testProcess", Collections.singletonMap("throwError", true));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"wait", (String)task.getTaskDefinitionKey());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        InputOutputTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        InputOutputTest.assertNotNull((Object)task);
        InputOutputTest.assertEquals((String)"taskError", (String)task.getTaskDefinitionKey());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().variableName("mapped").count());
        this.taskService.complete(task.getId());
        InputOutputTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment
    public void testScopeActivityInstanceId() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstance theTaskInstance = tree.getActivityInstances("theTask")[0];
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        InputOutputTest.assertEquals((String)theTaskInstance.getId(), (String)variableInstance.getActivityInstanceId());
    }
}

