/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler;

import org.camunda.bpm.engine.impl.cmmn.CaseControlRule;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.HumanTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.handler.HumanTaskItemHandler;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.test.cmmn.handler.CmmnElementHandlerTest;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.impl.instance.Body;
import org.camunda.bpm.model.cmmn.impl.instance.ConditionExpression;
import org.camunda.bpm.model.cmmn.impl.instance.DefaultControl;
import org.camunda.bpm.model.cmmn.impl.instance.ItemControl;
import org.camunda.bpm.model.cmmn.instance.CmmnElement;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.DiscretionaryItem;
import org.camunda.bpm.model.cmmn.instance.HumanTask;
import org.camunda.bpm.model.cmmn.instance.ManualActivationRule;
import org.camunda.bpm.model.cmmn.instance.PlanItemControl;
import org.camunda.bpm.model.cmmn.instance.PlanItemDefinition;
import org.camunda.bpm.model.cmmn.instance.PlanningTable;
import org.camunda.bpm.model.cmmn.instance.RequiredRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HumanTaskDicretionaryItemHandlerTest
extends CmmnElementHandlerTest {
    protected HumanTask humanTask;
    protected PlanningTable planningTable;
    protected DiscretionaryItem discretionaryItem;
    protected HumanTaskItemHandler handler = new HumanTaskItemHandler();

    @Before
    public void setUp() {
        this.humanTask = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aHumanTask", HumanTask.class);
        this.planningTable = this.createElement((CmmnModelElementInstance)this.casePlanModel, "aPlanningTable", PlanningTable.class);
        this.discretionaryItem = this.createElement((CmmnModelElementInstance)this.planningTable, "DI_aHumanTask", DiscretionaryItem.class);
        this.discretionaryItem.setDefinition((PlanItemDefinition)this.humanTask);
    }

    @Test
    public void testHumanTaskActivityName() {
        String name = "A HumanTask";
        this.humanTask.setName(name);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)name, (Object)activity.getName());
    }

    @Test
    public void testHumanTaskActivityType() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        String activityType = (String)activity.getProperty("activityType");
        Assert.assertEquals((Object)"humanTask", (Object)activityType);
    }

    @Test
    public void testHumanTaskDescription() {
        String description = "This is a humanTask";
        this.humanTask.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testDiscretionaryItemDescription() {
        String description = "This is a discretionaryItem";
        this.discretionaryItem.setDescription(description);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)description, (Object)((String)activity.getProperty("description")));
    }

    @Test
    public void testActivityBehavior() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        Assert.assertTrue((boolean)(behavior instanceof HumanTaskActivityBehavior));
    }

    @Test
    public void testIsBlockingEqualsTrueProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Boolean isBlocking = (Boolean)activity.getProperty("isBlocking");
        Assert.assertTrue((boolean)isBlocking);
    }

    @Test
    public void testIsBlockingEqualsFalseProperty() {
        this.humanTask.setIsBlocking(false);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertNull((Object)activity);
    }

    @Test
    public void testIsDiscretionaryProperty() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Boolean discretionary = (Boolean)activity.getProperty("discretionary");
        Assert.assertTrue((boolean)discretionary);
    }

    @Test
    public void testWithoutParent() {
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertNull((Object)activity.getParent());
    }

    @Test
    public void testWithParent() {
        CmmnCaseDefinition parent = new CmmnCaseDefinition("aParentActivity");
        this.context.setParent((CmmnActivity)parent);
        CmmnActivity activity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Assert.assertEquals((Object)parent, (Object)activity.getParent());
        Assert.assertTrue((boolean)parent.getActivities().contains(activity));
    }

    @Test
    public void testManualActivationRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.discretionaryItem, "ItemControl_1", ItemControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)itemControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testManualActivationRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.humanTask, "ItemControl_1", DefaultControl.class);
        ManualActivationRule manualActivationRule = this.createElement((CmmnModelElementInstance)defaultControl, "ManualActivationRule_1", ManualActivationRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)manualActivationRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("manualActivationRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRule() {
        ItemControl itemControl = this.createElement((CmmnModelElementInstance)this.discretionaryItem, "ItemControl_1", ItemControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)itemControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }

    @Test
    public void testRequiredRuleByDefaultPlanItemControl() {
        PlanItemControl defaultControl = (PlanItemControl)this.createElement((CmmnModelElementInstance)this.humanTask, "ItemControl_1", DefaultControl.class);
        RequiredRule requiredRule = this.createElement((CmmnModelElementInstance)defaultControl, "RequiredRule_1", RequiredRule.class);
        ConditionExpression expression = this.createElement((CmmnModelElementInstance)requiredRule, "Expression_1", ConditionExpression.class);
        Body body = this.createElement((CmmnModelElementInstance)expression, Body.class);
        body.setTextContent("${true}");
        Cmmn.validateModel((CmmnModelInstance)this.modelInstance);
        CmmnActivity newActivity = this.handler.handleElement((CmmnElement)this.discretionaryItem, this.context);
        Object rule = newActivity.getProperty("requiredRule");
        Assert.assertNotNull((Object)rule);
        Assert.assertTrue((boolean)(rule instanceof CaseControlRule));
    }
}

