/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class CompetingMessageCorrelationTest
extends ConcurrencyTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentCorrelationFailsWithOptimisticLockingException() {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread2.makeContinue();
        thread1.waitForSync();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentExclusiveCorrelation() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.makeContinue();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof ProcessEngineException));
        this.assertTextPresent("does not have a subscription to a message event with name 'Message'", thread2.getException().getMessage());
        thread1.join();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentExclusiveCorrelationToDifferentExecutions() throws InterruptedException {
        InvocationLogListener.reset();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance1.getId(), true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance2.getId(), true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread2.getException());
        CompetingMessageCorrelationTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterMessageUserTask").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void FAILING_testConcurrentExclusiveCorrelationToDifferentExecutionsCase2() throws InterruptedException {
        InvocationLogListener.reset();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance1.getId(), true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", instance2.getId(), true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)1, (int)InvocationLogListener.getInvocations());
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread2.getException());
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        CompetingMessageCorrelationTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().taskDefinitionKey("afterMessageUserTask").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void testConcurrentMixedCorrelation() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertTrue((thread2.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread2.getException() instanceof OptimisticLockingException));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/CompetingMessageCorrelationTest.catchMessageProcess.bpmn20.xml"})
    public void FAILING_testConcurrentMixedCorrelationCase2() throws InterruptedException {
        InvocationLogListener.reset();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", false));
        thread1.reportInterrupts();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableMessageCorrelationCommand("Message", true));
        thread2.reportInterrupts();
        thread1.waitForSync();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        CompetingMessageCorrelationTest.assertEquals((int)2, (int)InvocationLogListener.getInvocations());
        thread1.makeContinue();
        Thread.sleep(5000L);
        CompetingMessageCorrelationTest.assertNull((Object)thread1.getException());
        CompetingMessageCorrelationTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        thread2.waitUntilDone();
        CompetingMessageCorrelationTest.assertNull((Object)thread2.getException());
        Task afterMessageTask = (Task)this.taskService.createTaskQuery().singleResult();
        CompetingMessageCorrelationTest.assertNotNull((Object)afterMessageTask);
        CompetingMessageCorrelationTest.assertEquals((String)afterMessageTask.getTaskDefinitionKey(), (String)"afterMessageUserTask");
        thread1.join();
        CompetingMessageCorrelationTest.assertTrue((thread1.getException() != null ? 1 : 0) != 0);
        CompetingMessageCorrelationTest.assertTrue((boolean)(thread1.getException() instanceof OptimisticLockingException));
    }

    protected static class ControllableMessageCorrelationCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String messageName;
        protected boolean exclusive;
        protected String processInstanceId;

        public ControllableMessageCorrelationCommand(String messageName, boolean exclusive) {
            this.messageName = messageName;
            this.exclusive = exclusive;
        }

        public ControllableMessageCorrelationCommand(String messageName, String processInstanceId, boolean exclusive) {
            this(messageName, exclusive);
            this.processInstanceId = processInstanceId;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            MessageCorrelationBuilderImpl correlationBuilder = new MessageCorrelationBuilderImpl(commandContext, this.messageName);
            if (this.processInstanceId != null) {
                correlationBuilder.processInstanceId(this.processInstanceId);
            }
            if (this.exclusive) {
                correlationBuilder.correlateExclusively();
            } else {
                correlationBuilder.correlate();
            }
            this.monitor.sync();
            return null;
        }
    }

    public static class InvocationLogListener
    implements JavaDelegate {
        protected static AtomicInteger invocations = new AtomicInteger(0);

        public void execute(DelegateExecution execution) throws Exception {
            invocations.incrementAndGet();
        }

        public static void reset() {
            invocations.set(0);
        }

        public static int getInvocations() {
            return invocations.get();
        }
    }
}

