/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.db;

import java.util.List;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class JobEntityTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/db/processWithGatewayAndTwoEndEvents.bpmn20.xml"})
    public void testGatewayWithTwoEndEventsLastJobReAssignedToParentExe() {
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processKey).getId();
        List jobList = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        JobEntityTest.assertNotNull((Object)jobList);
        JobEntityTest.assertEquals((int)2, (int)jobList.size());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)1, (int)jobList.size());
        JobEntityTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().list().size());
        JobEntityTest.assertEquals((String)processInstanceId, (String)((Job)jobList.get(0)).getExecutionId());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)0, (int)jobList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/db/processGatewayAndTwoEndEventsPlusTimer.bpmn20.xml"})
    public void testGatewayWithTwoEndEventsLastTimerReAssignedToParentExe() {
        String processKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(processKey).getId();
        List jobList = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        JobEntityTest.assertNotNull((Object)jobList);
        JobEntityTest.assertEquals((int)2, (int)jobList.size());
        String timerId = ((Job)this.managementService.createJobQuery().timers().singleResult()).getId();
        this.managementService.executeJob(timerId);
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)1, (int)jobList.size());
        JobEntityTest.assertEquals((int)1, (int)this.runtimeService.createExecutionQuery().list().size());
        JobEntityTest.assertEquals((String)processInstanceId, (String)((Job)jobList.get(0)).getExecutionId());
        this.managementService.executeJob(((Job)jobList.get(0)).getId());
        jobList = this.managementService.createJobQuery().list();
        JobEntityTest.assertEquals((int)0, (int)jobList.size());
    }

    public void testInsertJobWithExceptionMessage() {
        String fittingThreeByteMessage = this.repeatCharacter("\u9faf", JobEntity.MAX_EXCEPTION_MESSAGE_LENGTH);
        MessageEntity threeByteJobEntity = new MessageEntity();
        threeByteJobEntity.setExceptionMessage(fittingThreeByteMessage);
        this.insertJob((JobEntity)threeByteJobEntity);
        this.deleteJob((JobEntity)threeByteJobEntity);
    }

    public void testJobExceptionMessageCutoff() {
        MessageEntity threeByteJobEntity = new MessageEntity();
        String message = this.repeatCharacter("a", JobEntity.MAX_EXCEPTION_MESSAGE_LENGTH * 2);
        threeByteJobEntity.setExceptionMessage(message);
        JobEntityTest.assertEquals((int)JobEntity.MAX_EXCEPTION_MESSAGE_LENGTH, (int)threeByteJobEntity.getExceptionMessage().length());
    }

    @Deployment
    public void FAILING_testLongProcessDefinitionKey() {
        String key = "myrealrealrealrealrealrealrealrealrealrealreallongprocessdefinitionkeyawesome";
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(key).getId();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        JobEntityTest.assertEquals((String)key, (String)job.getProcessDefinitionKey());
    }

    protected void insertJob(final JobEntity jobEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getJobManager().insert((DbEntity)jobEntity);
                return null;
            }
        });
    }

    protected void deleteJob(final JobEntity jobEntity) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getJobManager().delete((DbEntity)jobEntity);
                return null;
            }
        });
    }

    protected String repeatCharacter(String encodedCharacter, int numCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numCharacters; ++i) {
            sb.append(encodedCharacter);
        }
        return sb.toString();
    }
}

